/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DepthFirstSearch {
    private static final Logger logger = Logger.getLogger(DepthFirstSearch.class);
    private Map<SQLTable, VertexInfo> vertexInfo;
    private int visitTime;
    private LinkedList<SQLTable> finishOrder;

    public DepthFirstSearch(SQLDatabase db) throws SQLObjectException {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        SQLObjectUtils.findDescendentsByClass((SQLObject)db, SQLTable.class, tables);
        this.performSearch(tables);
    }

    public DepthFirstSearch(List<SQLTable> tables) throws SQLObjectException {
        this.performSearch(tables);
    }

    private void performSearch(List<SQLTable> tables) throws SQLObjectException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing Search on: " + tables));
        }
        this.vertexInfo = new HashMap<SQLTable, VertexInfo>();
        this.finishOrder = new LinkedList();
        for (SQLTable u : tables) {
            this.vertexInfo.put(u, new VertexInfo());
        }
        this.visitTime = 0;
        for (SQLTable u : tables) {
            VertexInfo vi = this.vertexInfo.get(u);
            if (!vi.isWhite()) continue;
            this.visit(u);
        }
    }

    private void visit(SQLTable u) throws SQLObjectException {
        VertexInfo vi = this.vertexInfo.get(u);
        vi.setDiscoveryTime(++this.visitTime);
        for (SQLRelationship r : u.getExportedKeys()) {
            SQLTable v = r.getFkTable();
            VertexInfo vi2 = this.vertexInfo.get(v);
            if (vi2 == null) {
                logger.debug((Object)("Skipping vertex " + v + " because it is not in the set of tables to search"));
                continue;
            }
            if (!vi2.isWhite()) continue;
            vi2.setPredecessor(u);
            this.visit(v);
        }
        vi.setFinishTime(++this.visitTime);
        this.finishOrder.addFirst(u);
    }

    public List<SQLTable> getFinishOrder() {
        return this.finishOrder;
    }

    private class VertexInfo {
        private int discoveryTime;
        private int finishTime;
        private SQLTable predecessor;

        private VertexInfo() {
        }

        public boolean isWhite() {
            return this.discoveryTime == 0 && this.finishTime == 0;
        }

        public boolean isGrey() {
            return this.discoveryTime != 0 && this.finishTime == 0;
        }

        public boolean isBlack() {
            return this.finishTime != 0;
        }

        public int getDiscoveryTime() {
            return this.discoveryTime;
        }

        public void setDiscoveryTime(int discoveryTime) {
            this.discoveryTime = discoveryTime;
        }

        public int getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(int finishTime) {
            this.finishTime = finishTime;
        }

        public SQLTable getPredecessor() {
            return this.predecessor;
        }

        public void setPredecessor(SQLTable predecessor) {
            this.predecessor = predecessor;
        }
    }
}

