/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.Alignment;
import jalview.Cluster;
import jalview.MSFfile;
import jalview.MyCanvas;
import jalview.Sequence;
import jalview.SequenceNode;
import jalview.TreeFile;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.io.IOException;
import java.util.Vector;

public class NJTree {
    TreeFile tf;
    Sequence[] sequence;
    float[][] distance;
    int noClus;
    Vector cluster;
    int[] done;
    int noseqs;
    int mini;
    int minj;
    float ri;
    float rj;
    Vector node;
    String type;
    String pwtype;

    public NJTree(Sequence[] sequenceArray, String string, String string2) {
        this.sequence = sequenceArray;
        this.node = new Vector();
        this.type = string;
        this.pwtype = string2;
        if (!string.equals("NJ")) {
            string = "AV";
        }
        if (!string2.equals("PID")) {
            string = "SW";
        }
        int n = 0;
        this.done = new int[sequenceArray.length];
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            this.done[n] = 0;
            ++n;
        }
        this.noseqs = n++;
        this.distance = this.findDistances();
        this.makeLeaves();
        this.noClus = this.cluster.size();
        this.cluster();
    }

    public void cluster() {
        while (this.noClus > 2) {
            if (this.type.equals("NJ")) {
                this.findMinNJDistance();
            } else {
                this.findMinDistance();
            }
            Cluster cluster = this.joinClusters(this.mini, this.minj);
            this.done[this.minj] = 1;
            this.cluster.setElementAt(null, this.minj);
            this.cluster.setElementAt(cluster, this.mini);
            --this.noClus;
        }
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.noseqs) {
            if (this.done[n3] != 1) {
                if (!bl) {
                    n2 = n3;
                    bl = true;
                } else {
                    n = n3;
                }
            }
            ++n3;
        }
        this.joinClusters(n, n2);
        this.tf = new TreeFile((SequenceNode)this.node.elementAt(n));
    }

    public Cluster joinClusters(int n, int n2) {
        float f = this.distance[n][n2];
        int n3 = ((Cluster)this.cluster.elementAt((int)n)).value.length;
        int n4 = ((Cluster)this.cluster.elementAt((int)n2)).value.length;
        int[] nArray = new int[n3 + n4];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = ((Cluster)this.cluster.elementAt((int)n)).value[n5];
            ++n5;
        }
        int n6 = n3;
        while (n6 < n3 + n4) {
            nArray[n6] = ((Cluster)this.cluster.elementAt((int)n2)).value[n6 - n3];
            ++n6;
        }
        Cluster cluster = new Cluster(nArray);
        this.ri = this.findr(n, n2);
        this.rj = this.findr(n2, n);
        if (this.type.equals("NJ")) {
            this.findClusterNJDistance(n, n2);
        } else {
            this.findClusterDistance(n, n2);
        }
        SequenceNode sequenceNode = new SequenceNode();
        sequenceNode.left = (SequenceNode)this.node.elementAt(n);
        sequenceNode.right = (SequenceNode)this.node.elementAt(n2);
        SequenceNode sequenceNode2 = (SequenceNode)this.node.elementAt(n);
        SequenceNode sequenceNode3 = (SequenceNode)this.node.elementAt(n2);
        if (this.type.equals("NJ")) {
            this.findNewNJDistances(sequenceNode2, sequenceNode3, f);
        } else {
            this.findNewDistances(sequenceNode2, sequenceNode3, f);
        }
        sequenceNode2.parent = sequenceNode;
        sequenceNode3.parent = sequenceNode;
        this.node.setElementAt(sequenceNode, n);
        return cluster;
    }

    public void findNewNJDistances(SequenceNode sequenceNode, SequenceNode sequenceNode2, float f) {
        sequenceNode.dist = (f + this.ri - this.rj) / 2.0f;
        sequenceNode2.dist = f - sequenceNode.dist;
        if (sequenceNode.dist < 0.0f) {
            sequenceNode.dist = 0.0f;
        }
        if (sequenceNode2.dist < 0.0f) {
            sequenceNode2.dist = 0.0f;
        }
    }

    public void findNewDistances(SequenceNode sequenceNode, SequenceNode sequenceNode2, float f) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        SequenceNode sequenceNode3 = sequenceNode;
        SequenceNode sequenceNode4 = sequenceNode2;
        while (sequenceNode3 != null) {
            f2 += sequenceNode3.dist;
            sequenceNode3 = (SequenceNode)sequenceNode3.left;
        }
        while (sequenceNode4 != null) {
            f3 += sequenceNode4.dist;
            sequenceNode4 = (SequenceNode)sequenceNode4.left;
        }
        sequenceNode.dist = f / 2.0f - f2;
        sequenceNode2.dist = f / 2.0f - f3;
    }

    public void findClusterDistance(int n, int n2) {
        int n3 = ((Cluster)this.cluster.elementAt((int)n)).value.length;
        int n4 = ((Cluster)this.cluster.elementAt((int)n2)).value.length;
        float[] fArray = new float[this.noseqs];
        int n5 = 0;
        while (n5 < this.noseqs) {
            fArray[n5] = n5 != n && n5 != n2 ? (this.distance[n][n5] * (float)n3 + this.distance[n2][n5] * (float)n4) / (float)(n3 + n4) : 0.0f;
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.noseqs) {
            this.distance[n][n6] = fArray[n6];
            this.distance[n6][n] = fArray[n6];
            ++n6;
        }
    }

    public void findClusterNJDistance(int n, int n2) {
        Cluster cfr_ignored_0 = (Cluster)this.cluster.elementAt(n);
        Cluster cfr_ignored_1 = (Cluster)this.cluster.elementAt(n2);
        float[] fArray = new float[this.noseqs];
        int n3 = 0;
        while (n3 < this.noseqs) {
            fArray[n3] = n3 != n && n3 != n2 ? (this.distance[n][n3] + this.distance[n2][n3] - this.distance[n][n2]) / 2.0f : 0.0f;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.noseqs) {
            this.distance[n][n4] = fArray[n4];
            this.distance[n4][n] = fArray[n4];
            ++n4;
        }
    }

    public float findr(int n, int n2) {
        float f = 1.0f;
        int n3 = 0;
        while (n3 < this.noseqs) {
            if (n3 != n && n3 != n2 && this.done[n3] != 1) {
                f += this.distance[n][n3];
            }
            ++n3;
        }
        if (this.noClus > 2) {
            f /= (float)(this.noClus - 2);
        }
        return f;
    }

    public float findMinNJDistance() {
        float f = 100000.0f;
        int n = 0;
        while (n < this.noseqs - 1) {
            int n2 = n + 1;
            while (n2 < this.noseqs) {
                float f2;
                if (this.done[n] != 1 && this.done[n2] != 1 && (f2 = this.distance[n][n2] - (this.findr(n, n2) + this.findr(n2, n))) < f) {
                    this.mini = n;
                    this.minj = n2;
                    f = f2;
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public float findMinDistance() {
        float f = 100000.0f;
        int n = 0;
        while (n < this.noseqs - 1) {
            int n2 = n + 1;
            while (n2 < this.noseqs) {
                if (this.done[n] != 1 && this.done[n2] != 1 && this.distance[n][n2] < f) {
                    this.mini = n;
                    this.minj = n2;
                    f = this.distance[n][n2];
                }
                ++n2;
            }
            ++n;
        }
        return f;
    }

    public float[][] findDistances() {
        float[][] fArray = new float[this.noseqs][this.noseqs];
        if (this.pwtype.equals("PID")) {
            int n = 0;
            while (n < this.noseqs - 1) {
                int n2 = n;
                while (n2 < this.noseqs) {
                    if (n2 == n) {
                        fArray[n][n] = 0.0f;
                    } else {
                        fArray[n][n2] = 100.0f - Alignment.compare(this.sequence[n], this.sequence[n2]);
                        fArray[n2][n] = fArray[n][n2];
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            int n;
            float f = -1.0f;
            int n3 = 0;
            while (n3 < this.noseqs - 1) {
                n = n3;
                while (n < this.noseqs) {
                    AlignSeq alignSeq = new AlignSeq(this.sequence[n3], this.sequence[n], "pep");
                    alignSeq.calcScoreMatrix();
                    alignSeq.traceAlignment();
                    alignSeq.printAlignment();
                    fArray[n3][n] = alignSeq.maxscore;
                    if (f < fArray[n3][n]) {
                        f = fArray[n3][n];
                    }
                    ++n;
                }
                ++n3;
            }
            n = 0;
            while (n < this.noseqs - 1) {
                int n4 = n;
                while (n4 < this.noseqs) {
                    fArray[n][n4] = f - fArray[n][n4];
                    fArray[n4][n] = fArray[n][n4];
                    ++n4;
                }
                ++n;
            }
        }
        return fArray;
    }

    public void makeLeaves() {
        this.cluster = new Vector();
        int n = 0;
        while (n < this.noseqs) {
            SequenceNode sequenceNode = new SequenceNode();
            sequenceNode.element = this.sequence[n];
            this.node.addElement(sequenceNode);
            int[] nArray = new int[]{n++};
            Cluster cluster = new Cluster(nArray);
            this.cluster.addElement(cluster);
        }
    }

    public static void main(String[] stringArray) {
        try {
            MSFfile mSFfile = new MSFfile(stringArray[0], "File");
            Sequence[] sequenceArray = new Sequence[mSFfile.seqs.size()];
            int n = 0;
            while (n < mSFfile.seqs.size()) {
                sequenceArray[n] = (Sequence)mSFfile.seqs.elementAt(n);
                ++n;
            }
            NJTree nJTree = new NJTree(sequenceArray, stringArray[1], stringArray[2]);
            Frame frame = new Frame();
            frame.setLayout(new BorderLayout());
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            MyCanvas myCanvas = new MyCanvas(nJTree.tf);
            panel.add("Center", myCanvas);
            frame.resize(600, 600);
            frame.add("Center", panel);
            frame.show();
            nJTree.tf.reCount(nJTree.tf.top);
            nJTree.tf.findHeight(nJTree.tf.top);
            nJTree.tf.printNode(nJTree.tf.top);
            nJTree.tf.draw(panel.getGraphics(), 500, 500);
            nJTree.tf.groupNodes(nJTree.tf.top, Float.valueOf(stringArray[3]).floatValue());
            return;
        }
        catch (IOException iOException) {
            System.out.println("Exception : " + iOException);
            return;
        }
    }
}

