/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MicrosoftEdgeBrowser
extends ExtWebBrowser {
    private static Boolean hidden;
    private static final long serialVersionUID = 4333320552804224866L;
    private static String appUserModelId;

    public static Boolean isHidden() {
        if (hidden == null) {
            hidden = Utilities.isWindows() ? Boolean.valueOf(MicrosoftEdgeBrowser.getAppUserModelId().isEmpty()) : Boolean.valueOf(true);
        }
        return hidden;
    }

    public MicrosoftEdgeBrowser() {
        super(PrivateBrowserFamilyId.EDGE);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage(MicrosoftEdgeBrowser.class, (String)"CTL_MicrosoftEdgeBrowserName");
        }
        return this.name;
    }

    @Override
    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        NbDdeBrowserImpl impl = null;
        if (MicrosoftEdgeBrowser.isHidden().booleanValue()) {
            throw new UnsupportedOperationException(NbBundle.getMessage(MicrosoftEdgeBrowser.class, (String)"MSG_CannotUseBrowser"));
        }
        impl = new NbDdeBrowserImpl(this);
        return impl;
    }

    @Override
    protected NbProcessDescriptor defaultBrowserExecutable() {
        String command = "cmd";
        String params = "/C start microsoft-edge:{URL}";
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "{0} MicrosoftEdge: defaultBrowserExecutable: {1}, {2}", new Object[]{System.currentTimeMillis(), params, command});
        }
        return new NbProcessDescriptor(command, params);
    }

    private static String getAppUserModelId() {
        if (appUserModelId == null) {
            File folder = new File("C:\\Windows\\SystemApps");
            String id = null;
            if (folder.exists()) {
                for (File file : folder.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.startsWith("Microsoft.MicrosoftEdge")) continue;
                    id = fileName;
                }
            }
            appUserModelId = id == null ? "" : id + "!MicrosoftEdge";
        }
        return appUserModelId;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }
}

