/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.imex;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.view.customization.ui.ViewletIconProvider;
import com.paterva.maltego.view.customization.ui.imex.SelectableViewlet;
import com.paterva.maltego.view.customization.ui.imex.ViewletExistInfo;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class ViewletNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public ViewletNode(String viewID, SelectableViewlet viewlet, ViewletExistInfo existInfo) {
        this(viewID, viewlet, new InstanceContent(), existInfo);
    }

    private ViewletNode(String viewID, SelectableViewlet viewlet, InstanceContent content, ViewletExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, viewlet);
        String displayName = viewlet.getViewlet().getName();
        if (existInfo != null && existInfo.exist(viewID, viewlet.getViewlet())) {
            if (existInfo.isReadOnly(viewID, viewlet.getViewlet())) {
                displayName = "<read-only> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        this.setShortDescription("");
        this.setSelectedNonRecursive(viewlet.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableViewlet viewlet) {
        content.add((Object)viewlet);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableViewlet viewlet = (SelectableViewlet)this.getLookup().lookup(SelectableViewlet.class);
            viewlet.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        SelectableViewlet viewlet = (SelectableViewlet)this.getLookup().lookup(SelectableViewlet.class);
        return ViewletIconProvider.getIcon(viewlet.getViewlet()).getImage();
    }
}

