/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.collab.session.xmpp.Utils;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationConnection;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.Base64;
import org.xmlpull.v1.XmlPullParser;

abstract class ServerValidationStrategy {
    private static final String ELEMENT_NAME = "auth";
    private static final String ELEMENT_NS = "maltego:collab:auth";

    ServerValidationStrategy() {
    }

    public abstract void checkServerCredentials(XmppCollaborationConnection var1, CollaborationSessionInfo var2) throws CollaborationException;

    static {
        ProviderManager.getInstance().addIQProvider(ELEMENT_NAME, ELEMENT_NS, (Object)new Provider());
    }

    private static class Provider
    implements IQProvider {
        private Provider() {
        }

        public IQ parseIQ(XmlPullParser xpp) throws Exception {
            String xml = Utils.stripOuterTags(xpp);
            String response = PayloadHelper.parsePayload("response", xml);
            ChallengeResponse cr = new ChallengeResponse();
            cr.setResponse(response);
            return cr;
        }
    }

    private static class ChallengeResponse
    extends IQ {
        private String _challenge;
        private String _response;

        public ChallengeResponse() {
            this.setType(IQ.Type.GET);
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("<%s xmlns=\"%s\">", ServerValidationStrategy.ELEMENT_NAME, ServerValidationStrategy.ELEMENT_NS));
            if (this.getChallenge() != null) {
                buf.append("<challenge>").append(this.getChallenge()).append("</challenge>");
            }
            if (this.getResponse() != null) {
                buf.append("<response>").append(this.getResponse()).append("</response>");
            }
            buf.append(String.format("</%s>", ServerValidationStrategy.ELEMENT_NAME));
            return buf.toString();
        }

        public String getChallenge() {
            return this._challenge;
        }

        public void setChallenge(String challenge) {
            this._challenge = challenge;
        }

        public String getResponse() {
            return this._response;
        }

        public void setResponse(String response) {
            this._response = response;
        }
    }

    public static class Paterva
    extends ServerValidationStrategy {
        private static final String KEY1 = "Ax8hKn48I";
        private static final String KEY2 = "F4Cvk&ds2scv";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkServerCredentials(XmppCollaborationConnection cn, CollaborationSessionInfo info) throws CollaborationException {
            ChallengeResponse request = new ChallengeResponse();
            String challenge = this.createChallenge();
            request.setChallenge(challenge);
            request.setTo(info.getService());
            PacketCollector collector = cn.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
            try {
                ChallengeResponse msg;
                String response;
                cn.sendPacket((Packet)request);
                IQ result = (IQ)collector.nextResult(info.getMessageTimeout());
                if (result != null && result.getType() == IQ.Type.RESULT && !this.verifyResponse(challenge, response = (msg = (ChallengeResponse)result).getResponse())) {
                    throw new CollaborationException("Unsupported server", false);
                }
            }
            finally {
                collector.cancel();
            }
        }

        private String createChallenge() throws CollaborationException {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(16);
                this.addUuid(buffer, UUID.randomUUID());
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] digest = md.digest(buffer.array());
                return Base64.encodeBytes((byte[])digest);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CollaborationException(ex, true);
            }
        }

        private ByteBuffer addUuid(ByteBuffer buffer, UUID id) {
            buffer.putLong(id.getMostSignificantBits());
            buffer.putLong(id.getLeastSignificantBits());
            return buffer;
        }

        private boolean verifyResponse(String challenge, String response) throws CollaborationException {
            try {
                String clear = this.decrypt(response, ArrayUtils.addAll((char[])ArrayUtils.addAll((char[])KEY1.toCharArray(), (char[])new char[]{'4', 'k', '7', 'g'}), (char[])KEY2.toCharArray()));
                return challenge.equals(clear);
            }
            catch (GeneralSecurityException ex) {
                throw new CollaborationException(ex, true);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CollaborationException(ex, true);
            }
        }

        private String createResponse(String challenge) throws CollaborationException {
            try {
                return this.encrypt(challenge, ArrayUtils.addAll((char[])ArrayUtils.addAll((char[])KEY1.toCharArray(), (char[])new char[]{'4', 'k', '7', 'g'}), (char[])KEY2.toCharArray()));
            }
            catch (GeneralSecurityException ex) {
                throw new CollaborationException(ex, true);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CollaborationException(ex, true);
            }
        }

        private String encrypt(String text, char[] key) throws GeneralSecurityException, UnsupportedEncodingException {
            SecretKey secret = this.expand(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(text.getBytes("UTF-8"));
            byte[] all = ArrayUtils.addAll((byte[])iv, (byte[])cipherText);
            return Base64.encodeBytes((byte[])all);
        }

        private String decrypt(String s, char[] key) throws GeneralSecurityException, UnsupportedEncodingException {
            byte[] ivAndCipherText = Base64.decode((String)s);
            byte[] iv = Arrays.copyOf(ivAndCipherText, 16);
            byte[] cipherText = Arrays.copyOfRange(ivAndCipherText, 16, ivAndCipherText.length);
            SecretKey secret = this.expand(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return new String(cipher.doFinal(cipherText), "UTF-8");
        }

        private SecretKey expand(char[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] salt = new byte[]{-120, -36, -88, -111, 33, 69, -52, -61};
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(key, salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            return secret;
        }
    }

    public static class Default
    extends ServerValidationStrategy {
        @Override
        public void checkServerCredentials(XmppCollaborationConnection cn, CollaborationSessionInfo info) throws CollaborationException {
            if (info.isUseDefaultServer() || info.isUsePrivatePatervaServer()) {
                new Paterva().checkServerCredentials(cn, info);
            }
        }
    }

    public static class None
    extends ServerValidationStrategy {
        @Override
        public void checkServerCredentials(XmppCollaborationConnection cn, CollaborationSessionInfo info) throws CollaborationException {
        }
    }
}

