/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileIO;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.Java2DProperty;
import com.paterva.maltego.java.config.Java2DSettings;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigFileReader
extends ConfigFileIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigOptions read() {
        FileInputStream fis;
        ConfigOptions options = new ConfigOptions();
        try {
            fis = new FileInputStream(this.getUserConfigFilePath());
        }
        catch (FileNotFoundException ex) {
            return options;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        Pattern memPattern = Pattern.compile("Xmx(\\d*)m");
        Matcher memMatcher = memPattern.matcher("");
        Pattern jrePattern = Pattern.compile("^\\s*jdkhome=\"([^\"]*)\"");
        Matcher jreMatcher = jrePattern.matcher("");
        Matcher ipv4Matcher = ConfigFileReader.getMatcher(IPVersion.getIPv4Stack().getKey());
        Matcher ipv6Matcher = ConfigFileReader.getMatcher(IPVersion.getIPv6Addresses().getKey());
        Matcher openGLMatcher = ConfigFileReader.getMatcher(Java2DProperty.getOpenGL().getKey());
        Matcher d3dMatcher = ConfigFileReader.getMatcher(Java2DProperty.getD3D().getKey());
        try {
            try {
                String aLine;
                IPVersion ipv4 = IPVersion.getIPv4Stack();
                IPVersion ipv6 = IPVersion.getIPv6Addresses();
                boolean javaIPManaged = true;
                Java2DProperty openGL = Java2DProperty.getOpenGL();
                Java2DProperty d3d = Java2DProperty.getD3D();
                while ((aLine = in.readLine()) != null) {
                    String jrePath;
                    JavaInfo info;
                    memMatcher.reset(aLine);
                    if (memMatcher.find()) {
                        String heapSize = memMatcher.group(1);
                        Integer maxHeapSize = Integer.parseInt(heapSize);
                        options.setMaxHeapSize(maxHeapSize);
                    }
                    jreMatcher.reset(aLine);
                    if (jreMatcher.find() && (info = JavaUtils.getInfo(new File(jrePath = jreMatcher.group(1)))) != null && JavaUtils.isValidVersion(info.getVersion())) {
                        System.out.println("jdkhome: " + jrePath);
                        options.setJavaRuntime(jrePath);
                    }
                    this.setJava2DPrefer(openGLMatcher, aLine, openGL);
                    this.setJava2DPrefer(d3dMatcher, aLine, d3d);
                    javaIPManaged = this.setIPPrefer(ipv4Matcher, aLine, ipv4, javaIPManaged);
                    javaIPManaged = this.setIPPrefer(ipv6Matcher, aLine, ipv6, javaIPManaged);
                }
                IPVersionSettings ipVersionSettings = new IPVersionSettings(ipv4, ipv6);
                ipVersionSettings.setManaged(javaIPManaged);
                options.setIpVersionSettings(ipVersionSettings);
                Java2DSettings java2DSettings = new Java2DSettings(openGL, d3d);
                options.setJava2DSettings(java2DSettings);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return options;
    }

    private static Matcher getMatcher(String patternKey) {
        Pattern pattern = Pattern.compile(patternKey + "=(True|true|False|false)");
        return pattern.matcher("");
    }

    private boolean setIPPrefer(Matcher ipvMatcher, String input, IPVersion ipv, boolean javaIPManaged) {
        ipvMatcher.reset(input);
        if (ipvMatcher.find()) {
            String value = ipvMatcher.group(1);
            Boolean state = Boolean.parseBoolean(value);
            ipv.setPrefer(state);
            javaIPManaged = false;
        }
        return javaIPManaged;
    }

    private void setJava2DPrefer(Matcher java2DMatcher, String input, Java2DProperty java2DProp) {
        java2DMatcher.reset(input);
        if (java2DMatcher.find()) {
            String value = java2DMatcher.group(1);
            Boolean state = Boolean.parseBoolean(value);
            java2DProp.setPrefer(state);
        }
    }
}

