/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xlightweb.AbstractHeader;
import org.xlightweb.HeaderlineParser;
import org.xlightweb.IHttpHeader;
import org.xsocket.connection.INonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractHttpHeader
extends AbstractHeader
implements IHttpHeader,
HeaderlineParser.IHeaderSink {
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SPACE = 32;
    static final byte HTAB = 9;
    static final String HOST = "Host";
    static final String USER_AGENT = "User-Agent";
    static final String SERVER = "Server";
    static final String DATE = "Date";
    static final String UPGRADE = "Upgrade";
    static final String CONNECTION = "Connection";
    static final String KEEP_ALIVE = "Keep-Alive";
    static final String CONTENT_LENGTH = "Content-Length";
    private int parsedChars = 0;
    private HashMap<String, Object> attributes = new HashMap();
    private String connection;
    private String upgrade;
    private int contentLength = -1;
    private String protocolScheme;
    private String protocolVersion;

    AbstractHttpHeader() {
    }

    final void setProtocolSchemeSilence(String protocolScheme) {
        this.protocolScheme = protocolScheme;
    }

    final String getProtocolScheme() {
        return this.protocolScheme;
    }

    final void setProtocolVersionSilence(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.protocolScheme + "/" + this.protocolVersion;
    }

    @Override
    public final void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    @Override
    public final Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public final Set<String> getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public final Enumeration getAttributeNames() {
        return Collections.enumeration(this.getAttributeNameSet());
    }

    int getCountParsedChars() {
        return this.parsedChars;
    }

    int incCountParsedChars(int parsedChars) {
        this.parsedChars += parsedChars;
        return this.parsedChars;
    }

    @Override
    public final int getContentLength() {
        return this.contentLength;
    }

    @Override
    public final void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public final String getUpgrade() {
        return this.upgrade;
    }

    @Override
    public final void setUpgrade(String upgrade) {
        this.upgrade = upgrade;
    }

    @Override
    public String getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Override
    public String getKeepAlive() {
        return this.getHeader(KEEP_ALIVE);
    }

    @Override
    public void setKeepAlive(String keepAlive) {
        this.setHeader(KEEP_ALIVE, keepAlive);
    }

    @Override
    public final void copyHeaderFrom(IHttpHeader otherHeader, String ... upperExcludenames) {
        block0: for (String headername : otherHeader.getHeaderNameSet()) {
            String upperheadername = headername.toUpperCase();
            for (String upperExcludename : upperExcludenames) {
                if (upperheadername.equals(upperExcludename)) continue block0;
            }
            for (String headervalue : otherHeader.getHeaderList(headername)) {
                this.addHeader(headername, headervalue);
            }
        }
    }

    @Override
    boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLength = Integer.parseInt(headervalue);
            return true;
        }
        if (headername.equalsIgnoreCase(CONNECTION)) {
            this.connection = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase(UPGRADE)) {
            this.upgrade = headervalue;
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            this.contentLength = -1;
            return true;
        }
        if (headername.equalsIgnoreCase(CONNECTION)) {
            this.connection = null;
            return true;
        }
        if (headername.equalsIgnoreCase(UPGRADE)) {
            this.upgrade = null;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public boolean containsHeader(String headername) {
        if (this.connection != null && headername.equalsIgnoreCase(CONNECTION)) {
            return true;
        }
        if (this.contentLength != -1 && headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            return true;
        }
        if (this.upgrade != null && headername.equalsIgnoreCase(UPGRADE)) {
            return true;
        }
        return super.containsHeader(headername);
    }

    @Override
    public Set<String> getHeaderNameSet() {
        HashSet<String> headerNames = new HashSet<String>();
        if (this.contentLength != -1) {
            headerNames.add(CONTENT_LENGTH);
        }
        if (this.connection != null) {
            headerNames.add(CONNECTION);
        }
        if (this.upgrade != null) {
            headerNames.add(UPGRADE);
        }
        headerNames.addAll(super.getHeaderNameSet());
        return headerNames;
    }

    @Override
    public List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase(CONNECTION)) {
            if (this.connection == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.connection);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(Integer.toString(this.contentLength));
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase(UPGRADE)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.upgrade);
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public String getHeader(String headername) {
        if (headername.equalsIgnoreCase(CONNECTION)) {
            if (this.connection == null) {
                return null;
            }
            return this.connection;
        }
        if (headername.equalsIgnoreCase(CONTENT_LENGTH)) {
            return Integer.toString(this.contentLength);
        }
        if (headername.equalsIgnoreCase(UPGRADE)) {
            if (this.upgrade == null) {
                return null;
            }
            return this.upgrade;
        }
        return super.getHeader(headername);
    }

    @Override
    final void writeHeadersTo(StringBuilder sb) {
        if (this.contentLength != -1) {
            sb.append("Content-Length: ");
            sb.append(this.contentLength);
            sb.append("\r\n");
        }
        if (this.connection != null) {
            sb.append("Connection: ");
            sb.append(this.connection);
            sb.append("\r\n");
        }
        if (this.upgrade != null) {
            sb.append("Upgrade: ");
            sb.append(this.upgrade);
            sb.append("\r\n");
        }
        super.writeHeadersTo(sb);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        AbstractHttpHeader copy = (AbstractHttpHeader)super.clone();
        copy.attributes = (HashMap)this.attributes.clone();
        return copy;
    }

    static String computeScheme(String protcolLeft, INonBlockingConnection connection) {
        if (protcolLeft == null || protcolLeft.equalsIgnoreCase("HTTP")) {
            if (connection.isSecure()) {
                return "https";
            }
            return "http";
        }
        return null;
    }
}

