/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.AttrAccept;
import com.kenai.jbosh.AttrAck;
import com.kenai.jbosh.AttrCharsets;
import com.kenai.jbosh.AttrHold;
import com.kenai.jbosh.AttrInactivity;
import com.kenai.jbosh.AttrMaxPause;
import com.kenai.jbosh.AttrPolling;
import com.kenai.jbosh.AttrRequests;
import com.kenai.jbosh.AttrSessionID;
import com.kenai.jbosh.AttrVersion;
import com.kenai.jbosh.AttrWait;
import com.kenai.jbosh.Attributes;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyQName;

final class CMSessionParams {
    private final AttrSessionID sid;
    private final AttrWait wait;
    private final AttrVersion ver;
    private final AttrPolling polling;
    private final AttrInactivity inactivity;
    private final AttrRequests requests;
    private final AttrHold hold;
    private final AttrAccept accept;
    private final AttrMaxPause maxPause;
    private final AttrAck ack;
    private final AttrCharsets charsets;
    private final boolean ackingRequests;

    private CMSessionParams(AttrSessionID aSid, AttrWait aWait, AttrVersion aVer, AttrPolling aPolling, AttrInactivity aInactivity, AttrRequests aRequests, AttrHold aHold, AttrAccept aAccept, AttrMaxPause aMaxPause, AttrAck aAck, AttrCharsets aCharsets, boolean amAckingRequests) {
        this.sid = aSid;
        this.wait = aWait;
        this.ver = aVer;
        this.polling = aPolling;
        this.inactivity = aInactivity;
        this.requests = aRequests;
        this.hold = aHold;
        this.accept = aAccept;
        this.maxPause = aMaxPause;
        this.ack = aAck;
        this.charsets = aCharsets;
        this.ackingRequests = amAckingRequests;
    }

    static CMSessionParams fromSessionInit(AbstractBody req, AbstractBody resp) throws BOSHException {
        AttrAck aAck = AttrAck.createFromString(resp.getAttribute(Attributes.ACK));
        String rid = req.getAttribute(Attributes.RID);
        boolean acking = aAck != null && ((String)aAck.getValue()).equals(rid);
        return new CMSessionParams(AttrSessionID.createFromString(CMSessionParams.getRequiredAttribute(resp, Attributes.SID)), AttrWait.createFromString(CMSessionParams.getRequiredAttribute(resp, Attributes.WAIT)), AttrVersion.createFromString(resp.getAttribute(Attributes.VER)), AttrPolling.createFromString(resp.getAttribute(Attributes.POLLING)), AttrInactivity.createFromString(resp.getAttribute(Attributes.INACTIVITY)), AttrRequests.createFromString(resp.getAttribute(Attributes.REQUESTS)), AttrHold.createFromString(resp.getAttribute(Attributes.HOLD)), AttrAccept.createFromString(resp.getAttribute(Attributes.ACCEPT)), AttrMaxPause.createFromString(resp.getAttribute(Attributes.MAXPAUSE)), aAck, AttrCharsets.createFromString(resp.getAttribute(Attributes.CHARSETS)), acking);
    }

    private static String getRequiredAttribute(AbstractBody body, BodyQName name) throws BOSHException {
        String attrStr = body.getAttribute(name);
        if (attrStr == null) {
            throw new BOSHException("Connection Manager session creation response did not include required '" + name.getLocalPart() + "' attribute");
        }
        return attrStr;
    }

    AttrSessionID getSessionID() {
        return this.sid;
    }

    AttrWait getWait() {
        return this.wait;
    }

    AttrVersion getVersion() {
        return this.ver;
    }

    AttrPolling getPollingInterval() {
        return this.polling;
    }

    AttrInactivity getInactivityPeriod() {
        return this.inactivity;
    }

    AttrRequests getRequests() {
        return this.requests;
    }

    AttrHold getHold() {
        return this.hold;
    }

    AttrAccept getAccept() {
        return this.accept;
    }

    AttrMaxPause getMaxPause() {
        return this.maxPause;
    }

    AttrAck getAck() {
        return this.ack;
    }

    AttrCharsets getCharsets() {
        return this.charsets;
    }

    boolean isAckingRequests() {
        return this.ackingRequests;
    }
}

