/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.graph;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.links.ConnectivityOptions;
import com.paterva.maltego.graph.table.io.links.LinkConnector;
import com.paterva.maltego.graph.table.ui.graph.ConnectivityPanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import org.openide.WizardDescriptor;

public final class ConnectivityController
extends ValidatingController<ConnectivityPanel> {
    private ConnectivityOptions _dco;
    private int previousEntityCount;
    private int previousLinkCount;

    public ConnectivityController() {
        this.setName("Connectivity Graph");
        this.previousEntityCount = 0;
        this.previousLinkCount = 0;
    }

    public void updateCounts(TabularGraph tabularGraph) {
        this.previousEntityCount = tabularGraph.getEntities().size();
        this.previousLinkCount = tabularGraph.getLinks().size();
        this.setDefaultLinks(tabularGraph);
    }

    public void setDefaultLinks(TabularGraph tabularGraph) {
        int entitySize = tabularGraph.getEntities().size();
        int linkSize = tabularGraph.getLinks().size();
        if ((this._dco == ConnectivityOptions.MANUAL || entitySize < 2 || linkSize != 0) && (this._dco == ConnectivityOptions.MANUAL || entitySize < 2 || this.previousEntityCount == entitySize && this.previousLinkCount == linkSize)) {
            return;
        }
        LinkConnector linkConnector = new LinkConnector();
        linkConnector.createLinks(tabularGraph, this._dco);
        this.previousEntityCount = tabularGraph.getEntities().size();
        this.previousLinkCount = tabularGraph.getLinks().size();
    }

    private void clearLinks(TabularGraph tg) {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        for (TabularGraphLink link : tg.getLinks()) {
            links.add(link);
        }
        for (TabularGraphLink link : links) {
            tg.removeLink(link);
        }
    }

    private void setDefaultConnectivityOptions(ConnectivityOptions dco, TabularGraph tg) {
        if (this._dco != dco) {
            this._dco = dco;
            if (dco != ConnectivityOptions.MANUAL) {
                this.clearLinks(tg);
            }
        }
    }

    protected ConnectivityPanel createComponent() {
        return new ConnectivityPanel();
    }

    protected void readSettings(WizardDescriptor settings) {
        ConnectivityOptions dco = (ConnectivityOptions)settings.getProperty("defaultConnectivityOptions");
        TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
        this.setDefaultConnectivityOptions(dco, tabularGraph);
        this.setDefaultLinks(tabularGraph);
        ((ConnectivityPanel)this.component()).setTabularGraph(tabularGraph, (JTabbedPane)settings.getProperty("mcTabbedPane"));
    }

    protected void storeSettings(WizardDescriptor settings) {
        TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
        List<TabularGraphLink> linksRemoved = ((ConnectivityPanel)this.component()).getLinksRemoved();
        for (TabularGraphLink link : linksRemoved) {
            tabularGraph.removeLink(link);
        }
        List<TabularGraphLink> linksAdded = ((ConnectivityPanel)this.component()).getLinksAdded();
        for (TabularGraphLink link : linksAdded) {
            tabularGraph.putLink(link);
        }
        this.previousEntityCount = tabularGraph.getEntities().size();
        this.previousLinkCount = tabularGraph.getLinks().size();
    }
}

