/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.convert;

import com.paterva.maltego.typing.convert.DefaultStringConverter;
import com.paterva.maltego.typing.convert.StringConverter;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.util.StringUtilities;

public class PhoneNumberStringConverter
implements StringConverter {
    @Override
    public Object convertFrom(String value, Class to) throws IllegalArgumentException {
        PhoneNumber result = null;
        if (!StringUtilities.isNullOrEmpty((String)value)) {
            try {
                result = PhoneNumber.parse(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot not convert '" + value + "' to Phone Number: " + ex.getMessage());
            }
        }
        return result;
    }

    @Override
    public String convertTo(Object value, Class from) throws IllegalArgumentException {
        if (value instanceof PhoneNumber) {
            PhoneNumber phoneNumber = (PhoneNumber)value;
            return phoneNumber.toString();
        }
        return DefaultStringConverter.instance().convertTo(value, from);
    }
}

