/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.execution.Property;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Link {
    private final String id;
    private final String sourceId;
    private final String targetId;
    private final List<Property> properties;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Link(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="sourceId") String sourceId, @JsonProperty(value="targetId") String targetId, @JsonProperty(value="properties") List<Property> properties) {
        this.id = id;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.id, link.id) && Objects.equals(this.sourceId, link.sourceId) && Objects.equals(this.targetId, link.targetId) && Objects.equals(this.properties, link.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sourceId, this.targetId, this.properties);
    }

    public static enum LinkStyle {
        SOLID(0),
        DASHED(1),
        DOTTED(2),
        DASHED_DOTTED(3);

        private final int styleCode;

        private LinkStyle(int styleCode) {
            this.styleCode = styleCode;
        }

        public int getStyleCode() {
            return this.styleCode;
        }

        public static LinkStyle get(int styleCode) {
            for (LinkStyle style : LinkStyle.values()) {
                if (style.getStyleCode() != styleCode) continue;
                return style;
            }
            return SOLID;
        }
    }
}

