/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.util.ActionUtils;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.MaltegoHelper;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import com.paterva.maltego.welcome.home.HomeOptions;
import com.paterva.maltego.welcome.home.HomeTopComponent;
import com.paterva.maltego.welcome.home.HomeVsOtherWindowsSynchronizer;
import com.paterva.maltego.welcome.reset.FactoryResetAction;
import com.paterva.maltego.welcome.reset.ResetWindowsAction;
import com.paterva.maltego.welcome.update.UpdateOptionProcessor;
import com.paterva.maltego.welcome.update.UpdateScheduler;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.keyring.Keyring;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;

public class Installer
extends ModuleInstall {
    private static final Logger LOGGER = Logger.getLogger(Installer.class.getName());
    private static final Logger LOBO_LOGGER = Logger.getLogger("org.lobobrowser");
    private static final Logger PARSING_LOGGER = Logger.getLogger("org.netbeans.modules.parsing");
    private static final Logger PROXY_LOGGER = Logger.getLogger("org.netbeans.core.network.proxy");
    private static final Logger INDEXING_LOGGER = Logger.getLogger("org.netbeans.ui.indexing");
    private static final Logger FILE_LOCATOR_LOGGER = Logger.getLogger("org.netbeans.core.startup.InstalledFileLocatorImpl");

    public void restored() {
        if (!MaltegoHelper.isSupportedJava()) {
            String msg = "This version of Java is not supported by Maltego.\n\nJava: " + MaltegoHelper.getJavaVersion();
            System.out.println(msg);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
            nd.setTitle("Java Version");
            nd.setMessageType(2);
            nd.setOptions((Object[])new String[]{"Exit"});
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            System.exit(9);
        }
        Keyring.read((String)"abc");
        LOBO_LOGGER.setLevel(Level.SEVERE);
        PARSING_LOGGER.setLevel(Level.WARNING);
        PROXY_LOGGER.setLevel(Level.WARNING);
        INDEXING_LOGGER.setLevel(Level.WARNING);
        FILE_LOCATOR_LOGGER.setLevel(Level.SEVERE);
        HomeVsOtherWindowsSynchronizer.instance();
        UIRunQueue uiRunQ = UIRunQueue.instance();
        uiRunQ.queue(100, "Possibly opening Home View (Start Page & Maltego Data Hub) ", () -> {
            StatusDisplayer.getDefault().setStatusText("");
            SlownessDetector.start();
            if (HomeOptions.isOpenAtStartup() && !HomeTopComponent.getInstance().hasOpened()) {
                Action action = ActionUtils.getAction((String)"Window", (String)"com-paterva-maltego-welcome-home-HomeAction");
                if (action != null) {
                    action.actionPerformed(null);
                } else {
                    LOGGER.severe("Home Page action not found");
                }
            }
        });
        uiRunQ.queue(5000, "Update Scheduler", () -> UpdateScheduler.instance().start());
        UpdateOptionProcessor.restoreUrl();
    }

    public void close() {
        if (ResetWindowsAction.isReset()) {
            FileObject configRoot = FileUtil.getConfigFile((String)"Windows2Local");
            this.delete(configRoot, "reset windows", new String[0]);
            HomeVsOtherWindowsSynchronizer.instance().reset();
        } else if (FactoryResetAction.isReset()) {
            LicenseManager licMan = LicenseManager.A();
            boolean mayFallbackToLicenseKey = licMan.I();
            FileObject configRoot = FileUtil.getConfigRoot();
            this.delete(configRoot, "factory reset", "Editors", "Maltego", "Preferences", "Windows2Local");
            licMan.I(mayFallbackToLicenseKey);
        }
    }

    private void delete(FileObject configRoot, String operation, String ... fileNames) {
        File file = FileUtil.toFile((FileObject)configRoot);
        if (file != null) {
            LOGGER.log(Level.WARNING, "Performing {0} for: {1}", new Object[]{operation, file.getAbsolutePath()});
            for (int i = 0; i < 10; ++i) {
                try {
                    if (!file.exists()) continue;
                    if (fileNames != null && fileNames.length > 0) {
                        block3: for (File subFile : file.listFiles()) {
                            for (String fileName : fileNames) {
                                if (!subFile.getName().endsWith(fileName)) continue;
                                FileUtilities.delete((File)subFile);
                                continue block3;
                            }
                        }
                        if (file.list().length != 0) continue;
                        FileUtilities.delete((File)file);
                        continue;
                    }
                    FileUtilities.delete((File)file);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (file.exists()) {
                LOGGER.log(Level.INFO, "Left over from {0}:", operation);
                this.recursiveLog(file, 0);
            } else {
                LOGGER.log(Level.INFO, "Nothing left over from {0}.", operation);
            }
        } else {
            LOGGER.log(Level.WARNING, "Could not find user dir for {0}.", operation);
        }
    }

    private void recursiveLog(File file, int depth) {
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            spaces.append(" ");
        }
        LOGGER.log(Level.INFO, "{0}{1}", new Object[]{spaces, file.getAbsolutePath()});
        File[] listFiles = file.listFiles();
        if (listFiles != null) {
            for (File f : listFiles) {
                this.recursiveLog(f, depth + 1);
            }
        }
    }
}

