/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui.view;

import com.paterva.maltego.tx.inputs.global.GlobalTransformInputDescriptor;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputGroup;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.util.ui.HeaderControl;
import com.paterva.maltego.util.ui.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.jdesktop.swingx.JXCollapsiblePane;

public class GlobalInputGroupPanel
extends JPanel {
    private static final Map<String, Object> FACTORY_SETTINGS = new TreeMap<String, Object>();
    private final GlobalTransformInputGroup _group;

    GlobalInputGroupPanel(GlobalTransformInputGroup group) {
        this._group = group;
        this.setLayout(new BorderLayout());
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color bgColor = laf.getColor("run-bg-color");
        Color headerBgColor = laf.getColor("palette-category-bg");
        Color headerFgColor = laf.getColor("palette-category-fg");
        JXCollapsiblePane cp = new JXCollapsiblePane();
        cp.setLayout((LayoutManager)new BorderLayout());
        Action toggleAction = cp.getActionMap().get("toggle");
        HeaderControl header = new HeaderControl(toggleAction, (Border)new MatteBorder(1, 0, 0, 0, bgColor), headerFgColor);
        toggleAction.putValue("Name", this._group.getDisplayName());
        toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon2"));
        toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon2"));
        Set inputs = group.getInputs();
        DisplayDescriptorCollection collection = this.toDisplayDescriptorCollection(inputs);
        DataSource dataSource = GlobalTransformInputsRepository.getDefault().getData();
        Component editorsControl = this.createEditorsControl(dataSource, collection);
        cp.add(editorsControl, (Object)"Center");
        editorsControl.setBackground(bgColor);
        cp.getContentPane().setBackground(bgColor);
        cp.setBackground(bgColor);
        this.setBackground(bgColor);
        header.setBackground(headerBgColor);
        header.setForeground(headerFgColor);
        this.add((Component)header, "North");
        this.add((Component)cp);
    }

    private Component createEditorsControl(DataSource ds, DisplayDescriptorCollection popups) {
        Component component = ComponentFactories.form(FACTORY_SETTINGS).createEditingComponent(ds, (DisplayDescriptorEnumeration)popups, null, (Border)new EmptyBorder(0, 10, 0, 0), (LayoutManager)new VFlowLayout(0, 3, 2));
        return component;
    }

    private DisplayDescriptorCollection toDisplayDescriptorCollection(Set<GlobalTransformInputDescriptor> inputs) {
        DisplayDescriptorList list = new DisplayDescriptorList();
        for (GlobalTransformInputDescriptor input : inputs) {
            if (input == null || input.getInput() == null) continue;
            list.add(input.getInput());
        }
        return list;
    }

    private void adjustSizes(Component component) {
        if (component instanceof JComponent) {
            JComponent comp = (JComponent)component;
            comp.setPreferredSize(null);
            if (component instanceof JTextField) {
                JTextField textField = (JTextField)component;
                textField.setColumns(3);
            } else {
                for (Component child : comp.getComponents()) {
                    this.adjustSizes(child);
                }
            }
        }
    }

    static {
        FACTORY_SETTINGS.put("showDescriptions", Boolean.TRUE);
        FACTORY_SETTINGS.put("useRequiredFieldColor", Boolean.FALSE);
    }
}

