/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui.imex;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputsExistInfo;
import com.paterva.maltego.tx.inputs.global.ui.imex.SelectableGlobalInput;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class GlobalInputNode
extends ConfigNode {
    private boolean _isCheckEnabled = true;

    public GlobalInputNode(SelectableGlobalInput input, GlobalInputsExistInfo existInfo) {
        this(input, new InstanceContent(), existInfo);
    }

    private GlobalInputNode(SelectableGlobalInput input, InstanceContent content, GlobalInputsExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, input);
        TransformPropertyDescriptor descriptor = input.getGlobalInput().getDescriptor();
        String displayName = descriptor.getDisplayName();
        if (existInfo != null && existInfo.exist(input.getGlobalInput())) {
            if (existInfo.isReadOnly(input.getGlobalInput())) {
                displayName = "<read-only> " + displayName;
                this._isCheckEnabled = false;
            } else {
                displayName = "<exist> " + displayName;
            }
        }
        this.setDisplayName(displayName);
        String description = descriptor.getName();
        if (StringUtilities.isNullOrEmpty((String)descriptor.getDescription())) {
            description = description + " - " + descriptor.getDescription();
        }
        this.setShortDescription(description);
        this.setSelectedNonRecursive(input.isSelected());
    }

    public boolean isCheckEnabled() {
        return this._isCheckEnabled;
    }

    private void addLookups(InstanceContent content, SelectableGlobalInput input) {
        content.add((Object)input);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableGlobalInput input = (SelectableGlobalInput)this.getLookup().lookup(SelectableGlobalInput.class);
            input.setSelected(selected);
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/Transform.png", (boolean)true);
    }
}

