/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.privacymode;

import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class PrivacyModeSettings {
    public static final String PROP_MODE_SET = "PrivacyModeSet";
    private static final Logger LOG = Logger.getLogger(PrivacyModeSettings.class.getName());
    private static final PrivacyModeSettings INSTANCE = new PrivacyModeSettings();
    private static final String PREF_PRIVACY_MODE_SETTINGS = "PrivacyModeSettings";
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public static PrivacyModeSettings getInstance() {
        return INSTANCE;
    }

    public boolean isPrivacyModeSet() {
        return this.getPreferences().get(PREF_PRIVACY_MODE_SETTINGS, null) != null;
    }

    public void setPrivacyMode(PrivacyMode mode) {
        Args.notNull((Object)((Object)mode), (String)"mode");
        this.getPreferences().put(PREF_PRIVACY_MODE_SETTINGS, mode.name());
        this._support.firePropertyChange(PROP_MODE_SET, null, (Object)mode);
    }

    public PrivacyMode getPrivacyMode() {
        PrivacyMode mode = PrivacyMode.DEFAULT_MODE;
        String modeName = this.getPreferences().get(PREF_PRIVACY_MODE_SETTINGS, null);
        if (modeName != null) {
            try {
                mode = PrivacyMode.valueOf(modeName);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.WARNING, "Privacy mode does not exist (it might have been removed): {0}", modeName);
            }
        }
        return mode;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(listener);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(PrivacyModeSettings.class);
    }
}

