/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.button;

import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class CollapseExpandButton
extends JButton {
    private static final Icon UP_ARROW = ImageUtilities.loadImageIcon((String)"org/officelaf/ribbon/images/up_arrow_dark.png", (boolean)true);
    private static final Icon UP_ARROW_HOVER = ImageUtilities.loadImageIcon((String)"org/officelaf/ribbon/images/up_arrow_yellow.png", (boolean)true);
    private static final Icon DOWN_ARROW = ImageUtilities.loadImageIcon((String)"org/officelaf/ribbon/images/down_arrow_dark.png", (boolean)true);
    private static final Icon DOWN_ARROW_HOVER = ImageUtilities.loadImageIcon((String)"org/officelaf/ribbon/images/down_arrow_yellow.png", (boolean)true);
    private final Preferences PREFS = NbPreferences.forModule(this.getClass());
    private final JComponent component;
    private final String preferenceName;

    public CollapseExpandButton(JComponent component, String preferenceName) {
        this.component = component;
        this.preferenceName = preferenceName;
        this.init();
        this.setBorderPainted(false);
        this.setPreferredSize(new Dimension(22, 22));
    }

    private void init() {
        boolean expanded = this.PREFS.getBoolean(this.preferenceName, true);
        this.component.setVisible(expanded);
        this.updateCollapsedIcon();
        this.addActionListener(__ -> this.actionPerformed());
    }

    private void actionPerformed() {
        boolean expanded = !this.component.isVisible();
        this.component.setVisible(expanded);
        this.PREFS.putBoolean(this.preferenceName, expanded);
        this.updateCollapsedIcon();
    }

    private void updateCollapsedIcon() {
        this.setIcon(this.component.isVisible() ? DOWN_ARROW : UP_ARROW);
    }

    @Override
    public Icon getRolloverIcon() {
        return this.component.isVisible() ? DOWN_ARROW_HOVER : UP_ARROW_HOVER;
    }
}

