/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.bypass;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.graph.store.views.impl.tools.UncollectUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BypassCollectionRule
implements CollectStrategy {
    private final InMemoryCollectionNodes _collectionNodes;
    private final Set<EntityID> _touchedViewEntities = new HashSet<EntityID>();

    public BypassCollectionRule(InMemoryCollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        Iterator<EntityID> entItr = entities.keySet().iterator();
        while (entItr.hasNext()) {
            EntityID entity = entItr.next();
            ViewEntity viewEntity = new ViewEntity(msd.getEntityType(entity), entities.get(entity));
            msd.addToCollectedViewEntities(entity, viewEntity);
            entItr.remove();
        }
        Iterator<LinkID> lnkItr = links.keySet().iterator();
        while (lnkItr.hasNext()) {
            LinkID link = lnkItr.next();
            LinkEntityIDs ids = links.get(link);
            ViewLink viewLink = new ViewLink(ids);
            msd.addToCollectedViewLinks(link, viewLink);
            lnkItr.remove();
        }
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        this._touchedViewEntities.clear();
        Set entitiesAdded = imsm.getEntitiesAdded();
        Set entitiesRemoved = imsm.getEntitiesRemoved();
        Set<EntityID> entitiesFromlinksAdded = UncollectUtils.lookupAddedEnts(this._collectionNodes, imsm.getLinksAdded(), entitiesAdded);
        Set<EntityID> entitiesFromlinksRemoved = UncollectUtils.lookupRemovedEnts(imsm.getLinksRemoved());
        this.addToTouched(entitiesRemoved);
        this.addToTouched(entitiesFromlinksAdded);
        this.addToTouched(entitiesFromlinksRemoved);
        return this._touchedViewEntities;
    }

    private void addToTouched(Set<EntityID> entities) throws GraphStoreException {
        for (EntityID entityID : entities) {
            this._touchedViewEntities.add(this._collectionNodes.getViewEntity(entityID));
        }
    }
}

