/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.util;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class GraphUtils {
    private static final Logger LOG = Logger.getLogger(GraphUtils.class.getName());

    public static Set<String> getTypeNames(GraphID graphID, EntityRegistry registry) {
        Set<String> allTypeNames = Collections.emptySet();
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            Set typeNames = dataReader.getEntityTypes();
            LOG.log(Level.FINE, "Store Types: {0}", typeNames);
            allTypeNames = GraphUtils.getAllTypeNames(typeNames, registry, false);
            LOG.log(Level.FINE, "All Types: {0}", allTypeNames);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return allTypeNames;
    }

    public static Set<String> getAllTypeNames(Set<String> typeNames, EntityRegistry registry, boolean addSingleParents) {
        HashSet<String> parentTypes = new HashSet<String>();
        HashSet<String> allTypeNames = new HashSet<String>();
        for (String typeName : typeNames) {
            List inherited = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)typeName);
            boolean isFirst = true;
            for (String typeName2 : inherited) {
                if (isFirst) {
                    allTypeNames.add(typeName2);
                    isFirst = false;
                    continue;
                }
                if (addSingleParents || parentTypes.contains(typeName2)) {
                    allTypeNames.add(typeName2);
                    continue;
                }
                parentTypes.add(typeName2);
            }
        }
        return allTypeNames;
    }

    public static List<MaltegoEntitySpec> getSortedSpecs(EntityRegistry registry, Set<String> typeNames) {
        ArrayList<MaltegoEntitySpec> specs = new ArrayList<MaltegoEntitySpec>();
        for (String typeName : typeNames) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
            if (spec == null || !spec.isVisible()) continue;
            specs.add(spec);
        }
        Collections.sort(specs, new TypeSpecDisplayNameComparator());
        return specs;
    }

    public static String getTopGraphName(TopComponent tc, String defaultName) {
        String name = defaultName;
        GraphDataObject gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
        if (gdo != null && gdo.getName() != null) {
            name = gdo.getName();
        }
        return name;
    }
}

