/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.TransactionBatcher;
import com.paterva.maltego.util.SimilarStrings;

public class TransactionGeneralBatcher
extends TransactionBatcher {
    private final GraphID _graphID;
    private SimilarStrings _description;

    public TransactionGeneralBatcher(GraphID graphID) {
        super(GraphTransactorRegistry.getDefault().get(graphID));
        this._graphID = graphID;
    }

    public synchronized void entityBookmarkChanged(MaltegoEntity entity, int before, int after) {
        if (before != after) {
            this._description = new SimilarStrings("Change bookmark(s)");
            MaltegoEntity entityBefore = entity.createClone();
            MaltegoEntity entityAfter = entity.createClone();
            entityBefore.setBookmark(Integer.valueOf(before));
            entityAfter.setBookmark(Integer.valueOf(after));
            ModifiedHelper.updateModified(GraphUser.getUser(this._graphID), (MaltegoPart<? extends Guid>)entityAfter);
            GraphTransaction transaction = GraphTransactionHelper.createEntityUpdateTransaction(entityBefore, entityAfter);
            GraphTransaction inverseTransaction = GraphTransactionHelper.createEntityUpdateTransaction(entityAfter, entityBefore);
            this.addTransaction(transaction, inverseTransaction);
        }
    }

    @Override
    protected SimilarStrings getDescription() {
        return this._description;
    }
}

