/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.api;

import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.protocol.api.TransformInfo;
import com.paterva.maltego.transform.protocol.api.TransformInputDescriptor;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;

public abstract class TransformTranslator<T extends TransformInfo> {
    private final Set<TransformSet> _sets;

    public TransformTranslator(Set<TransformSet> sets) {
        this._sets = sets;
    }

    public abstract TransformDescriptor translate(T var1, URL var2);

    protected String[] findSets(String transform) {
        ArrayList<String> sets = new ArrayList<String>();
        for (TransformSet set : this._sets) {
            if (!set.contains(transform)) continue;
            sets.add(set.getName());
        }
        return sets.toArray(new String[sets.size()]);
    }

    public static String getV2Name(String v3Name) {
        return v3Name.substring(11);
    }

    public abstract String getV3Name(String var1);

    public static DisplayDescriptorCollection translate(Set<TransformInputDescriptor> inputs) {
        DisplayDescriptorList descriptors = new DisplayDescriptorList();
        for (TransformInputDescriptor input : inputs) {
            TransformPropertyDescriptor dd = new TransformPropertyDescriptor(input.getType(), input.getName(), input.getDisplayName());
            dd.setDescription(input.getDescription());
            dd.setDefaultValue(input.getDefaultValue());
            dd.setHidden(false);
            dd.setNullable(!input.isRequired());
            dd.setPopup(input.isPopup());
            dd.setReadonly(false);
            dd.setAbstract(false);
            dd.setPersistence(PersistenceMode.Normal);
            dd.setVisibility(Visibility.Public);
            dd.setAuth(input.isAuth());
            dd.setGlobal(input.isGlobal());
            descriptors.add((DisplayDescriptor)dd);
        }
        return descriptors;
    }
}

