/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.awt.Color;

public class ColorUtil {
    private static final int RGB_MAX = 255;

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static Color fromHex(String str) {
        if (!str.startsWith("#")) {
            throw new IllegalArgumentException("Should be String starting with #.");
        }
        str = str.substring(1);
        if (str.length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 4) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(3)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        if (str.length() == 8) {
            Color opaque = Color.decode("0x" + str.substring(0, 6));
            return new Color(opaque.getRed(), opaque.getGreen(), opaque.getBlue(), Integer.parseInt(str.substring(6, 8), 16));
        }
        throw new IllegalArgumentException("Should be String of 3, 4, 6, or 8 chars length.");
    }

    public static Color fromHex(String str, Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isDark(Color c) {
        return 1.0 - (0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue()) / 255.0 >= 0.5;
    }

    public static Color invert(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }
}

