/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.ActionRegistry;
import com.paterva.maltego.automation.actions.AgeFilter;
import com.paterva.maltego.automation.actions.AllFilter;
import com.paterva.maltego.automation.actions.BookmarkAction;
import com.paterva.maltego.automation.actions.BookmarkedFilter;
import com.paterva.maltego.automation.actions.ClearBookmarkAction;
import com.paterva.maltego.automation.actions.DeleteAction;
import com.paterva.maltego.automation.actions.DeleteBranchAction;
import com.paterva.maltego.automation.actions.ExportImageAction;
import com.paterva.maltego.automation.actions.LinkCountFilter;
import com.paterva.maltego.automation.actions.LogAction;
import com.paterva.maltego.automation.actions.PropertyFilter;
import com.paterva.maltego.automation.actions.RootAncestorCountFilter;
import com.paterva.maltego.automation.actions.RootAncestorsFilter;
import com.paterva.maltego.automation.actions.RunTransformAction;
import com.paterva.maltego.automation.actions.RunTransformByNameAction;
import com.paterva.maltego.automation.actions.SaveAsAction;
import com.paterva.maltego.automation.actions.SendToUrlMachineAction;
import com.paterva.maltego.automation.actions.SetLayoutAction;
import com.paterva.maltego.automation.actions.StatusAction;
import com.paterva.maltego.automation.actions.TypeFilter;
import com.paterva.maltego.automation.actions.ValueFilter;
import com.paterva.maltego.automation.actions.userfilter.UserFilterAction;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import java.util.HashMap;
import java.util.Map;

public class DefaultActionRegistry
extends ActionRegistry {
    private final Map<String, Class<? extends Action>> _actions = new HashMap<String, Class<? extends Action>>();

    public DefaultActionRegistry() {
        this.register("userFilter", UserFilterAction.class);
        this.register("type", TypeFilter.class);
        this.register("age", AgeFilter.class);
        this.register("incoming", LinkCountFilter.Incoming.class);
        this.register("outgoing", LinkCountFilter.Outgoing.class);
        this.register("degree", LinkCountFilter.Degree.class);
        this.register("value", ValueFilter.class);
        this.register("property", PropertyFilter.class);
        this.register("delete", DeleteAction.class);
        this.register("log", LogAction.class);
        this.register("deleteBranch", DeleteBranchAction.class);
        this.register("run", RunTransformByNameAction.class);
        this.register("setLayout", SetLayoutAction.class);
        this.register("status", StatusAction.class);
        this.register("saveAs", SaveAsAction.class);
        this.register("exportImage", ExportImageAction.class);
        this.register("bookmark", BookmarkAction.class);
        this.register("clearBookmark", ClearBookmarkAction.class);
        this.register("bookmarked", BookmarkedFilter.class);
        this.register("rootAncestorCount", RootAncestorCountFilter.class);
        this.register("rootAncestors", RootAncestorsFilter.class);
        this.register("sendToURL", SendToUrlMachineAction.class);
        this.register("all", AllFilter.class);
    }

    public final void register(String name, Class<? extends Action> clazz) {
        if (this._actions.get(name) != null) {
            throw new IllegalStateException(String.format("Action '%s' already exists", name));
        }
        this._actions.put(name, clazz);
    }

    public final void deregister(String name) {
        this._actions.remove(name);
    }

    private Action getNamedAction(String name) {
        Class<? extends Action> clazz = this._actions.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    @Override
    public Action get(String name) {
        Action action = this.getNamedAction(name);
        if (action == null) {
            TransformDefinition transform = TransformRepositoryRegistry.getDefault().findTransform(name);
            if (transform != null) {
                return new RunTransformAction(transform);
            }
            return null;
        }
        return action;
    }
}

