/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import java.util.Objects;

public class CloudGraphSchemaVersion
implements Comparable<CloudGraphSchemaVersion> {
    public static final CloudGraphSchemaVersion SCHEMA_VERSION_0_0_0 = new CloudGraphSchemaVersion(0, 0, 0);
    public static final CloudGraphSchemaVersion SCHEMA_VERSION_1_0_0 = new CloudGraphSchemaVersion(1, 0, 0);
    public static final CloudGraphSchemaVersion SCHEMA_VERSION_2_0_0 = new CloudGraphSchemaVersion(2, 0, 0);
    private final int major;
    private final int minor;
    private final int patch;

    public CloudGraphSchemaVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static CloudGraphSchemaVersion parse(String versionString) {
        if (versionString == null || versionString.trim().isEmpty()) {
            return SCHEMA_VERSION_0_0_0;
        }
        try {
            String[] parts;
            versionString = versionString.trim();
            if (versionString.endsWith(".")) {
                versionString = versionString.substring(0, versionString.length() - 1);
            }
            if ((parts = versionString.split("\\.")).length == 3) {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int patch = Integer.parseInt(parts[2]);
                return new CloudGraphSchemaVersion(major, minor, patch);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return SCHEMA_VERSION_0_0_0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(CloudGraphSchemaVersion other) {
        if (other == null) {
            return 1;
        }
        int majorComparison = Integer.compare(this.major, other.major);
        if (majorComparison != 0) {
            return majorComparison;
        }
        int minorComparison = Integer.compare(this.minor, other.minor);
        if (minorComparison != 0) {
            return minorComparison;
        }
        return Integer.compare(this.patch, other.patch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CloudGraphSchemaVersion other = (CloudGraphSchemaVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean isGreaterThan(CloudGraphSchemaVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(CloudGraphSchemaVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLessThan(CloudGraphSchemaVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(CloudGraphSchemaVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isMissingVersion() {
        return this.equals(SCHEMA_VERSION_0_0_0);
    }
}

