/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TransformRunOrigin {
    private final RunSource runSource;
    private final String originName;
    private final String hashedOriginName;

    private TransformRunOrigin(RunSource runSource, String originName) {
        this.runSource = runSource;
        this.originName = originName;
        this.hashedOriginName = TransformRunOrigin.hashString(originName);
    }

    public static TransformRunOrigin fromMachineRun(String name) {
        return new TransformRunOrigin(RunSource.MACHINE, name);
    }

    public static TransformRunOrigin fromSetRun(String name) {
        return new TransformRunOrigin(RunSource.SET, name);
    }

    public static TransformRunOrigin fromDirectRun() {
        return new TransformRunOrigin(RunSource.DIRECT, null);
    }

    public RunSource getRunSource() {
        return this.runSource;
    }

    public String getOriginName() {
        return this.originName;
    }

    public String getHashedOriginName() {
        return this.hashedOriginName;
    }

    public static String hashString(String input) {
        try {
            if (input == null) {
                return null;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return TransformRunOrigin.bytesToHex(encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static enum RunSource {
        SET,
        MACHINE,
        DIRECT;

    }
}

