/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.auth;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.util.ui.problemreport.settings.ProblemReportOptions;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.keycloak.OAuthErrorException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class CloudAuthKeycloakInstalled {
    private static final Logger LOG = Logger.getLogger(CloudAuthKeycloakInstalled.class.getName());
    private static final String KEYCLOAK_JSON = "META-INF/keycloak.json";
    private static final String LOGGED_OUT = "logout";
    private static final int LOGOUT_DESKTOP_TIMEOUT = 20;
    private static final int LOGOUT_SILENT_TIMEOUT = 15000;
    private KeycloakDeployment deployment;
    private int listenPort = 0;
    private String listenHostname = "localhost";
    private AccessTokenResponse tokenResponse;
    private String tokenString;
    private String idTokenString;
    private IDToken idToken;
    private AccessToken token;
    private String refreshToken;
    private Status status;
    private Locale locale;
    Pattern callbackPattern = Pattern.compile("callback\\s*=\\s*\"([^\"]+)\"");
    Pattern paramPattern = Pattern.compile("param=\"([^\"]+)\"\\s+label=\"([^\"]+)\"\\s+mask=(\\S+)");
    Pattern codePattern = Pattern.compile("code=([^&]+)");
    private CallbackListener callback;
    private CallbackListener logoutCallback;
    private DesktopProvider desktopProvider = new DesktopProvider();
    private String messageLoginSuccess = "Login successful. You may close this browser window and go back to your desktop application.";
    private String messageLogoutSuccess = "Logged out. You may close this browser window.";
    private String messageError = "There was an error";
    private boolean isMessageHTML = false;
    private Path loginSuccessPath;
    private Path logoutSuccessPath;
    private LoginDesktopParams loginDesktopParams;

    public CloudAuthKeycloakInstalled() {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_JSON);
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public CloudAuthKeycloakInstalled(InputStream config) {
        this.deployment = KeycloakDeploymentBuilder.build((InputStream)config);
    }

    public CloudAuthKeycloakInstalled(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setMessageLoginSuccess(String msg) {
        this.messageLoginSuccess = msg;
    }

    public void setMessageError(String msg) {
        this.messageError = msg;
    }

    public void setMessageLogoutSuccess(String msg) {
        this.messageLogoutSuccess = msg;
    }

    public void setIsMessageHTML(Boolean isMessageHTML) {
        this.isMessageHTML = isMessageHTML;
    }

    public void setLoginSuccessPath(Path path) {
        this.loginSuccessPath = path;
    }

    public void setLogoutSuccessPath(Path path) {
        this.logoutSuccessPath = path;
    }

    public void setListenPort(int listenPort) {
        if (listenPort < 0 || listenPort > 65535) {
            throw new IllegalArgumentException("localPort");
        }
        this.listenPort = listenPort;
    }

    public String getListenHostname() {
        return this.listenHostname;
    }

    public void setListenHostname(String listenHostname) {
        this.listenHostname = listenHostname;
    }

    public void login(boolean enforceReAuthentication, boolean showOrgSelection) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop(false, enforceReAuthentication, showOrgSelection);
        } else {
            this.loginManual(enforceReAuthentication, showOrgSelection);
        }
    }

    public void login(PrintStream printer, Reader reader, boolean enforceReAuthentication, boolean showOrgSelection) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop(true, enforceReAuthentication, showOrgSelection);
        } else {
            this.loginManual(printer, reader, enforceReAuthentication, showOrgSelection);
        }
    }

    public void logout(boolean silent) throws IOException, InterruptedException, URISyntaxException {
        try {
            if (silent) {
                this.logoutSilent();
            } else if (this.status == Status.LOGGED_DESKTOP) {
                this.logoutDesktop();
            }
        }
        catch (Exception e) {
            Level logLevel = Level.WARNING;
            if (ProblemReportOptions.getDefault().isAutoSendExceptions()) {
                logLevel = Level.SEVERE;
            }
            LOG.log(logLevel, "logout(silent=" + silent + ") caused an error", e);
            throw e;
        }
        finally {
            LOG.info("Cleanup tokens after logout");
            this.tokenString = null;
            this.token = null;
            this.idTokenString = null;
            this.idToken = null;
            this.refreshToken = null;
            this.status = null;
        }
    }

    private void createLoginDesktopParams(boolean enforceReAuthentication, boolean showOrgSelection) {
        if (this.callback != null) {
            this.callback.stop();
        }
        this.callback = new CallbackListener();
        this.callback.start();
        String redirectUri = this.getRedirectUri(this.callback);
        String state = UUID.randomUUID().toString();
        Pkce pkce = this.deployment.isPkce() ? this.generatePkce() : null;
        String authUrl = this.createAuthUrl(redirectUri, state, pkce, enforceReAuthentication, showOrgSelection);
        this.loginDesktopParams = new LoginDesktopParams(redirectUri, state, pkce, authUrl);
    }

    public String getLoginDesktopUrl(boolean enforceReAuthentication, boolean showOrgSelection) {
        this.createLoginDesktopParams(enforceReAuthentication, showOrgSelection);
        return this.loginDesktopParams.getAuthUrl();
    }

    public void loginDesktop(boolean useSystemBrowser, boolean enforceReAuthentication, boolean showOrgSelection) throws IOException, VerificationException, OAuthErrorException, URISyntaxException, ServerRequest.HttpFailure, InterruptedException {
        if (useSystemBrowser || this.loginDesktopParams == null) {
            this.createLoginDesktopParams(enforceReAuthentication, showOrgSelection);
            this.desktopProvider.browse(new URI(this.loginDesktopParams.getAuthUrl()));
        }
        try {
            this.callback.await();
        }
        catch (InterruptedException e) {
            this.callback.stop();
            throw e;
        }
        if (this.callback.error != null) {
            throw new OAuthErrorException(this.callback.error, this.callback.errorDescription);
        }
        if (!this.loginDesktopParams.getState().equals(this.callback.state)) {
            throw new VerificationException("Invalid state");
        }
        this.processCode(this.callback.code, this.loginDesktopParams.getRedirectUri(), this.loginDesktopParams.getPkce());
        this.status = Status.LOGGED_DESKTOP;
        this.loginDesktopParams = null;
    }

    public void close() {
        if (this.callback != null) {
            this.callback.stop();
        }
    }

    protected String createAuthUrl(String redirectUri, String state, Pkce pkce, boolean enforceReAuthentication, boolean showOrgSelection) {
        KeycloakUriBuilder builder = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("scope", new Object[]{"openid organization offline_access"});
        if (state != null) {
            builder.queryParam("state", new Object[]{state});
        }
        if (this.locale != null) {
            builder.queryParam("ui_locales", new Object[]{this.locale.getLanguage()});
        }
        if (pkce != null) {
            builder.queryParam("code_challenge", new Object[]{pkce.getCodeChallenge()});
            builder.queryParam("code_challenge_method", new Object[]{"S256"});
        }
        if (enforceReAuthentication) {
            builder.queryParam("prompt", new Object[]{"login"});
        }
        builder.queryParam("login_source", new Object[]{"desktop"});
        builder.queryParam("refresh", new Object[]{true});
        if (showOrgSelection) {
            builder.queryParam("showOrgSelection", new Object[]{"true"});
        }
        return builder.build(new Object[0]).toString();
    }

    protected Pkce generatePkce() {
        return Pkce.generatePkce();
    }

    public String getLogoutDesktopUrl(boolean silent) {
        LOG.log(Level.INFO, "Creating logout URL for silent={0}", Boolean.toString(silent));
        if (this.idTokenString == null) {
            return null;
        }
        if (this.logoutCallback == null && !silent) {
            this.logoutCallback = new CallbackListener();
            this.logoutCallback.start();
        } else if (this.logoutCallback != null && silent) {
            this.logoutCallback.stop();
            this.logoutCallback = null;
        }
        KeycloakUriBuilder keycloakUriBuilder = this.deployment.getLogoutUrl().clone().queryParam("id_token_hint", new Object[]{this.idTokenString});
        if (!silent) {
            String logoutRedirectUri = this.getRedirectUri(this.logoutCallback);
            LOG.log(Level.INFO, "Logout callback: {0}", logoutRedirectUri);
            String redirectUri = String.format("%s?%s=%s", logoutRedirectUri, LOGGED_OUT, Boolean.toString(true));
            keycloakUriBuilder.queryParam("post_logout_redirect_uri", new Object[]{redirectUri});
        }
        return keycloakUriBuilder.build(new Object[0]).toString();
    }

    private void logoutDesktop() throws IOException, URISyntaxException, InterruptedException {
        String logoutUrl = this.getLogoutDesktopUrl(false);
        if (logoutUrl == null) {
            throw new IOException("No valid logout URL!");
        }
        LOG.log(Level.INFO, "Logging out through browser: {0}", logoutUrl);
        this.desktopProvider.browse(new URI(logoutUrl));
        try {
            boolean finishedBeforeTimeout = this.logoutCallback.await(20);
            if (finishedBeforeTimeout) {
                LOG.log(Level.INFO, "Logging out through browser successful");
            } else {
                LOG.log(Level.WARNING, "Logging out through browser hit the timeout");
            }
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Logging out through browser interrupted", e);
            this.logoutCallback.stop();
            throw e;
        }
        finally {
            this.logoutCallback = null;
        }
    }

    private void logoutSilent() throws IOException {
        try {
            String logoutUrl = this.getLogoutDesktopUrl(true);
            if (logoutUrl == null) {
                throw new IOException("No valid logout URL!");
            }
            LOG.log(Level.INFO, "Logging out silently: {0}", logoutUrl);
            HttpAgent httpAgent = new HttpAgent(new URL(logoutUrl));
            httpAgent.setConnectTimeout(15000);
            httpAgent.setReadTimeout(15000);
            httpAgent.doGet();
            int responseCode = httpAgent.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                LOG.log(Level.INFO, "Silent logout successful: {0}", responseCode);
            } else {
                String errorAsString = httpAgent.getErrorAsString();
                LOG.log(Level.WARNING, "Silent logout failed: {0}\nError body: {1}", new Object[]{responseCode, errorAsString});
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Silent logout failed", e);
            throw e;
        }
    }

    private String getRedirectUri(CallbackListener callback) {
        return String.format("http://%s:%s", this.getListenHostname(), callback.getLocalPort());
    }

    public void loginManual(boolean enforceReAuthentication, boolean showOrgSelection) throws IOException, ServerRequest.HttpFailure, VerificationException {
        this.loginManual(System.out, new InputStreamReader(System.in), enforceReAuthentication, showOrgSelection);
    }

    public void loginManual(PrintStream printer, Reader reader, boolean enforceReAuthentication, boolean showOrgSelection) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        Pkce pkce = this.generatePkce();
        String authUrl = this.createAuthUrl(redirectUri, null, pkce, enforceReAuthentication, showOrgSelection);
        printer.println("Open the following URL in a browser. After login copy/paste the code back and press <enter>");
        printer.println(authUrl);
        printer.println();
        printer.print("Code: ");
        String code = this.readCode(reader);
        this.processCode(code, redirectUri, pkce);
        this.status = Status.LOGGED_MANUAL;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getTokenString(long minValidity, TimeUnit unit) throws VerificationException, IOException, ServerRequest.HttpFailure {
        long expires = (long)this.token.getExpiration() * 1000L - unit.toMillis(minValidity);
        if (expires < System.currentTimeMillis()) {
            this.refreshToken();
        }
        return this.tokenString;
    }

    public void refreshToken() throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)this.refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    public void refreshToken(String refreshToken) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh((KeycloakDeployment)this.deployment, (String)refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    private void parseAccessToken(AccessTokenResponse tokenResponse) throws VerificationException {
        this.tokenResponse = tokenResponse;
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens((String)this.tokenString, (String)this.idTokenString, (KeycloakDeployment)this.deployment);
        this.token = tokens.getAccessToken();
        this.idToken = tokens.getIdToken();
        if (this.status == null) {
            this.status = this.isDesktopSupported() ? Status.LOGGED_DESKTOP : Status.LOGGED_MANUAL;
        }
    }

    public AccessToken getToken() {
        return this.token;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    public void setDesktopProvider(DesktopProvider desktopProvider) {
        this.desktopProvider = desktopProvider;
    }

    public boolean isDesktopSupported() {
        return this.desktopProvider.isDesktopSupported();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private void processCode(String code, String redirectUri, Pkce pkce) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)this.deployment, (String)code, (String)redirectUri, null, (String)(pkce == null ? null : pkce.getCodeVerifier()));
        this.parseAccessToken(tokenResponse);
    }

    private String readCode(Reader reader) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != ' ' && c != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    private static class LoginDesktopParams {
        private final String redirectUri;
        private final String state;
        private final Pkce pkce;
        private final String authUrl;

        public LoginDesktopParams(String redirectUri, String state, Pkce pkce, String authUrl) {
            this.redirectUri = redirectUri;
            this.state = state;
            this.pkce = pkce;
            this.authUrl = authUrl;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public String getState() {
            return this.state;
        }

        public Pkce getPkce() {
            return this.pkce;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }
    }

    public static class DesktopProvider {
        private static final String DEFAULT_SYSTEM_BROWSER = "<Default System Browser>";
        private static final String MICROSOFT_EDGE = "Microsoft Edge";

        public boolean isDesktopSupported() {
            return Desktop.isDesktopSupported();
        }

        public void browse(URI uri) throws IOException {
            if (Utilities.isWindows()) {
                HtmlBrowser.FactoryEditor editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
                String name = editor.getAsText();
                boolean useDesktopBrowse = DEFAULT_SYSTEM_BROWSER.equals(name);
                boolean useEdge = MICROSOFT_EDGE.equals(name);
                if (useDesktopBrowse) {
                    LOG.fine("Using Desktop.browse() for default browser selection on Windows");
                    Desktop.getDesktop().browse(uri);
                } else if (useEdge) {
                    try {
                        boolean didCmdFail;
                        LOG.fine("Running 'cmd.exe /c start msedge {URL}' command for Microsoft Edge on Windows");
                        String uriString = uri.toString();
                        Process exec = Runtime.getRuntime().exec("cmd.exe /c start msedge \"" + uriString + "\"");
                        StringBuilder errorOutput = new StringBuilder();
                        InputStream errorStream = exec.getErrorStream();
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
                        errorReader.lines().forEach(e -> errorOutput.append((String)e).append(System.lineSeparator()));
                        String errorString = errorOutput.toString().trim();
                        boolean bl = didCmdFail = !errorString.isEmpty();
                        if (didCmdFail) {
                            LOG.warning("Microsoft Edge command failed: " + errorString);
                        }
                    }
                    catch (IOException e2) {
                        LOG.log(Level.WARNING, "Running 'cmd.exe /c start msedge {URL}' command for Microsoft Edge caused issue, falling back to default URLDisplayer", e2);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(uri.toURL());
                    }
                } else {
                    LOG.fine("Using HtmlBrowser.URLDisplayer.showURL() for browser selection");
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uri.toURL());
                }
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uri.toURL());
            }
        }
    }

    public static class Pkce {
        public static final int PKCE_CODE_VERIFIER_MAX_LENGTH = 128;
        private final String codeChallenge;
        private final String codeVerifier;

        public Pkce(String codeVerifier, String codeChallenge) {
            this.codeChallenge = codeChallenge;
            this.codeVerifier = codeVerifier;
        }

        public String getCodeChallenge() {
            return this.codeChallenge;
        }

        public String getCodeVerifier() {
            return this.codeVerifier;
        }

        public static Pkce generatePkce() {
            try {
                String codeVerifier = SecretGenerator.getInstance().randomString(128);
                String codeChallenge = Pkce.generateS256CodeChallenge(codeVerifier);
                return new Pkce(codeVerifier, codeChallenge);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not generate PKCE", ex);
            }
        }

        private static String generateS256CodeChallenge(String codeVerifier) throws Exception {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
            return Base64Url.encode((byte[])md.digest());
        }
    }

    class CallbackListener
    implements HttpHandler {
        private final CountDownLatch shutdownSignal = new CountDownLatch(1);
        private String code;
        private String error;
        private String errorDescription;
        private String state;
        private Undertow server;
        private GracefulShutdownHandler gracefulShutdownHandler;

        CallbackListener() {
        }

        public void start() {
            PathHandler pathHandler = Handlers.path().addExactPath("/", (HttpHandler)this);
            AllowedMethodsHandler allowedMethodsHandler = new AllowedMethodsHandler((HttpHandler)pathHandler, new HttpString[]{Methods.GET});
            this.gracefulShutdownHandler = Handlers.gracefulShutdown((HttpHandler)allowedMethodsHandler);
            this.server = Undertow.builder().setIoThreads(1).setWorkerThreads(1).addHttpListener(CloudAuthKeycloakInstalled.this.getListenPort(), CloudAuthKeycloakInstalled.this.getListenHostname()).setHandler((HttpHandler)this.gracefulShutdownHandler).build();
            this.server.start();
        }

        public void stop() {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shutdownSignal.countDown();
        }

        public int getLocalPort() {
            return ((InetSocketAddress)((Undertow.ListenerInfo)this.server.getListenerInfo().get(0)).getAddress()).getPort();
        }

        public void await() throws InterruptedException {
            this.shutdownSignal.await();
        }

        public boolean await(int seconds) throws InterruptedException {
            return this.shutdownSignal.await(seconds, TimeUnit.SECONDS);
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.gracefulShutdownHandler.shutdown();
            Path page = null;
            String msg = CloudAuthKeycloakInstalled.this.messageLoginSuccess;
            if (CloudAuthKeycloakInstalled.this.loginSuccessPath != null) {
                page = CloudAuthKeycloakInstalled.this.loginSuccessPath;
            }
            if (!exchange.getQueryParameters().isEmpty()) {
                this.readQueryParameters(exchange);
            }
            if (this.error != null) {
                msg = CloudAuthKeycloakInstalled.this.messageError;
                page = null;
            } else {
                String is_logged_out = this.getQueryParameterIfPresent(exchange, CloudAuthKeycloakInstalled.LOGGED_OUT);
                if (is_logged_out != null) {
                    LOG.log(Level.INFO, "Logout callback is invoked by keycloak");
                    msg = CloudAuthKeycloakInstalled.this.messageLogoutSuccess;
                    page = CloudAuthKeycloakInstalled.this.logoutSuccessPath;
                }
            }
            exchange.setStatusCode(302);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, CloudAuthKeycloakInstalled.this.isMessageHTML ? "text/html" : "text/plain");
            if (page != null && CloudAuthKeycloakInstalled.this.isMessageHTML) {
                try {
                    byte[] fileBytes = Files.readAllBytes(page);
                    msg = new String(fileBytes, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, e.getMessage());
                }
            }
            exchange.getResponseSender().send(msg);
            exchange.endExchange();
            this.shutdownSignal.countDown();
            ForkJoinPool.commonPool().execute(this::stop);
        }

        private void readQueryParameters(HttpServerExchange exchange) {
            this.code = this.getQueryParameterIfPresent(exchange, "code");
            this.error = this.getQueryParameterIfPresent(exchange, "error");
            this.errorDescription = this.getQueryParameterIfPresent(exchange, "error_description");
            this.state = this.getQueryParameterIfPresent(exchange, "state");
        }

        private String getQueryParameterIfPresent(HttpServerExchange exchange, String name) {
            Map queryParameters = exchange.getQueryParameters();
            return queryParameters.containsKey(name) ? (String)((Deque)queryParameters.get(name)).getFirst() : null;
        }
    }

    private static enum Status {
        LOGGED_MANUAL,
        LOGGED_DESKTOP;

    }
}

