/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class ListSearchable
extends AbstractSearchable {
    protected JXList list;

    public ListSearchable(JXList list) {
        this.list = list;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult searchResult = null;
        if (backwards) {
            for (int index = startRow; index >= 0 && searchResult == null; --index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        } else {
            for (int index = startRow; index < this.getSize() && searchResult == null; ++index) {
                searchResult = this.findMatchAt(pattern, index);
            }
        }
        this.updateState(searchResult);
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row);
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
        Matcher matcher;
        String text = this.list.getStringAt(row);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, 0);
        }
        return null;
    }

    protected int getSize() {
        return this.list.getElementCount();
    }

    public JXList getTarget() {
        return this.list;
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void moveMatchBySelection() {
        if (!this.hasMatch()) {
            return;
        }
        this.list.setSelectedIndex(this.lastSearchResult.foundRow);
        this.list.ensureIndexIsVisible(this.lastSearchResult.foundRow);
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter searchHL = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(searchHL);
        this.list.ensureIndexIsVisible(this.lastSearchResult.foundRow);
    }

    protected void removeHighlighter(Highlighter searchHighlighter) {
        this.list.removeHighlighter(searchHighlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.list.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.list.addHighlighter(highlighter);
    }
}

