/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.table.HeaderTypeOptions;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.EntityHitCounter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openide.util.Lookup;

public final class EntityDetector {
    private static EntityDetector detector;
    private final char NEW_LINE = (char)10;
    private final char[] charDataCheckArr = new char[]{'@', '.'};
    private final int maxNumberOfRowsToAttemptDetection = 10;
    private final int minimumRowsRequiredForMiscMatching = 4;
    private final int minimumDifferenceRequiredForMiscMatching = 3;
    private final String PROPERTY_HASH = "#";
    private final String PROPERTY_EQUALS = "=";
    private final String PHRASE = "maltego.Phrase";
    private final TypeSpecDisplayNameComparator comparator;
    private final ArrayList<MaltegoEntitySpec> mappableItems = new ArrayList();
    private final EntityStringConverter converter;
    private final HashMap<Integer, String> map;
    private TabularGraph tg;

    public static EntityDetector getInstance() {
        if (detector == null) {
            detector = new EntityDetector();
        }
        return detector;
    }

    private EntityDetector() {
        this.comparator = new TypeSpecDisplayNameComparator();
        this.converter = (EntityStringConverter)Lookup.getDefault().lookup(EntityStringConverter.class);
        this.map = new HashMap();
    }

    public void detectEntities(TabularGraph tg, File file) throws IOException {
        if (tg == null) {
            return;
        }
        this.tg = tg;
        this.mappableItems.clear();
        this.mappableItems.addAll(EntityRegistry.getDefault().getAllVisible());
        Collections.sort(this.mappableItems, this.comparator);
        this.map.clear();
        int linesToAttemps = 10;
        ArrayList<List<Object>> tableData = new ArrayList<List<Object>>();
        int columnCount = 0;
        TabularGraphFileImporter importer = TabularGraphFileImporterFactory.createImporter(file).get();
        try (TabularGraphIterator tgi = importer.open();){
            while (tgi.hasNext() && --linesToAttemps >= 0) {
                List<Object> row = tgi.getRow(null);
                columnCount = Math.max(columnCount, row.size());
                tableData.add(row);
                tgi.next();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        tg.setColumnCount(columnCount);
        if (this.performTypeRowDetection((List)tableData.get(0))) {
            if (tableData.size() > 1 && this.performHeaderRowDetection(1, tableData)) {
                tg.setHeaderTypeOptions(HeaderTypeOptions.TYPE_THEN_HEAD);
            } else {
                tg.setHeaderTypeOptions(HeaderTypeOptions.TYPE_ONLY);
            }
        } else if (tableData.size() > 1 && this.performTypeRowDetection((List)tableData.get(1))) {
            tg.setHeaderTypeOptions(HeaderTypeOptions.HEAD_THEN_TYPE);
        } else {
            this.performHeaderRowDetection(0, tableData);
        }
        ArrayList<List<Object>> tableDataCopy = new ArrayList<List<Object>>(tableData);
        if (tg.hasHeaderRow() && tg.hasTypeRow()) {
            tableData.remove(0);
            tableData.remove(0);
        } else if (tg.hasHeaderRow() || tg.hasTypeRow()) {
            tableData.remove(0);
        }
        boolean foundHeaderRow = this.performDataMatch(tableData, tg.hasHeaderRow());
        if (!tg.hasHeaderRow() && (foundHeaderRow || this.performLastDitchEffortToFindHeader(tableData))) {
            tg.setHeaderTypeOptions(tg.hasTypeRow() ? HeaderTypeOptions.TYPE_THEN_HEAD : HeaderTypeOptions.HEAD_ONLY);
        }
        for (int i = 0; i < tg.getColumnCount(); ++i) {
            if (this.hasColumnBeenMapped(i)) continue;
            this.putEntity("maltego.Phrase", i);
        }
        this.updateColumnNames(tableDataCopy);
    }

    protected void updateColumnNames(List<List<Object>> tableData) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < this.tg.getColumnCount(); ++i) {
            Object columnName;
            Object object = columnName = !this.tg.hasHeaderRow() ? null : tableData.get(this.tg.getHeaderRowIndex()).get(i);
            if (columnName == null) {
                columnName = "Column" + (i + 1);
            }
            columnNames.add(columnName.toString());
        }
        String[] names = columnNames.toArray(new String[columnNames.size()]);
        this.tg.setColumnNames(names);
    }

    private boolean performTypeRowDetection(List<Object> row) {
        boolean hasTypeRow = false;
        block0: for (int i = 0; i < row.size(); ++i) {
            Object get;
            if (this.hasColumnBeenMapped(i) || (get = row.get(i)) == null) continue;
            String field = get.toString().toLowerCase().trim();
            for (MaltegoEntitySpec mes : this.mappableItems) {
                String name = mes.getTypeName().toLowerCase();
                if (!field.startsWith(name)) continue;
                int firstIndex = field.indexOf("#");
                int lastIndex = field.lastIndexOf("=");
                if (firstIndex >= 0 && (lastIndex < 0 || lastIndex >= 0 && firstIndex < lastIndex) || firstIndex < 0 && lastIndex >= 0) {
                    this.scanForLinkedColumns(i, row, firstIndex, lastIndex);
                } else {
                    this.putEntity(mes.getTypeName(), i);
                }
                hasTypeRow = true;
                continue block0;
            }
        }
        return hasTypeRow;
    }

    private void scanForLinkedColumns(int col, List<Object> row, int firstIndex, int lastIndex) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        columns.add(col);
        String entitySpecNameFull = row.get(col).toString().trim();
        int esnFullLength = entitySpecNameFull.length();
        String entitySpecName = firstIndex >= 0 ? entitySpecNameFull.substring(0, firstIndex) : entitySpecNameFull.substring(0, lastIndex);
        if (entitySpecName.isEmpty()) {
            return;
        }
        if (firstIndex < 0 && lastIndex >= esnFullLength - 1) {
            this.putEntity(entitySpecName, col);
            return;
        }
        String colID = null;
        if (lastIndex >= 0) {
            colID = entitySpecNameFull.substring(lastIndex + 1, esnFullLength);
        }
        for (int i = col + 1; i < row.size(); ++i) {
            String colTypeName;
            Object get;
            if (this.hasColumnBeenMapped(i) || i == col || (get = row.get(i)) == null) continue;
            String colData = get.toString().trim();
            int colDataLength = colData.length();
            int colFirstIndex = colData.indexOf("#");
            int colLastIndex = colData.lastIndexOf("=");
            if (colFirstIndex < 0 && colLastIndex < 0 || colData.equalsIgnoreCase(entitySpecNameFull)) continue;
            String id = null;
            if (colLastIndex >= 0 && colLastIndex < colDataLength - 1) {
                id = colData.substring(colLastIndex + 1, colDataLength);
            }
            if (!Objects.equals(colID, id) || !(colTypeName = colFirstIndex >= 0 ? colData.substring(0, colFirstIndex) : colData.substring(0, colLastIndex)).equalsIgnoreCase(entitySpecName)) continue;
            columns.add(i);
        }
        this.putEntityWithProperties(entitySpecName, row, columns);
    }

    private boolean performHeaderRowDetection(int rowIndex, List<List<Object>> tableData) {
        boolean hasHeaderRow = false;
        List<Object> row = tableData.get(rowIndex);
        block0: for (int i = 0; i < row.size(); ++i) {
            String field;
            Object get = row.get(i);
            if (get == null || (field = get.toString().toLowerCase()).isEmpty()) continue;
            if (this.hasColumnBeenMapped(i)) {
                String typeName = this.map.get(i);
                String displayString = this.getDisplayString(typeName);
                if (!typeName.toLowerCase().contains(field) && (displayString == null || !displayString.toLowerCase().contains(field))) continue;
                hasHeaderRow = true;
                continue;
            }
            for (MaltegoEntitySpec mes : this.mappableItems) {
                if (!mes.getDisplayName().equalsIgnoreCase(field)) continue;
                this.putEntity(mes.getTypeName(), i);
                hasHeaderRow = true;
                continue block0;
            }
        }
        return hasHeaderRow;
    }

    private boolean performDataMatch(List<List<Object>> tableData, boolean hasHeaderRow) {
        if (tableData.isEmpty()) {
            return false;
        }
        int mightHaveHeaderCounter = 0;
        StringBuilder sb = new StringBuilder();
        ArrayList<EntityHitCounter> counters = new ArrayList<EntityHitCounter>();
        for (int i = 0; i < tableData.get(0).size(); ++i) {
            if (this.hasColumnBeenMapped(i) && hasHeaderRow) continue;
            sb.setLength(0);
            counters.clear();
            String firstRowType = null;
            for (int k = 0; k < tableData.size(); ++k) {
                Iterator iterator;
                Object get;
                List<Object> row = tableData.get(k);
                if (i >= row.size() || (get = row.get(i)) == null) continue;
                sb.append(get).append('\n');
                if (k != 0 || hasHeaderRow || !(iterator = this.converter.convert(get.toString()).iterator()).hasNext()) continue;
                firstRowType = ((MaltegoEntity)iterator.next()).getTypeName();
            }
            if (sb.toString().trim().isEmpty()) continue;
            for (MaltegoEntity entity : this.converter.convert(sb.toString())) {
                Object ehc = new EntityHitCounter(entity.getTypeName());
                int indexOf = counters.indexOf(ehc);
                if (indexOf >= 0) {
                    ehc = (EntityHitCounter)counters.remove(indexOf);
                }
                ((EntityHitCounter)ehc).incrementCount();
                counters.add((EntityHitCounter)ehc);
            }
            Collections.sort(counters);
            EntityHitCounter mostHitEHC = (EntityHitCounter)counters.get(0);
            if (mostHitEHC.getTypeName().equals("maltego.Phrase")) continue;
            if (counters.size() == 1) {
                if (this.hasColumnBeenMapped(i)) continue;
                this.putEntity(((EntityHitCounter)counters.get(0)).getTypeName(), i);
                continue;
            }
            int rows = !hasHeaderRow ? -1 : 0;
            for (EntityHitCounter c : counters) {
                rows += c.getCount();
            }
            if (mostHitEHC.getCount() < rows - 1) continue;
            if (!this.hasColumnBeenMapped(i)) {
                this.putEntity(((EntityHitCounter)counters.get(0)).getTypeName(), i);
            }
            if (hasHeaderRow || firstRowType == null) continue;
            EntityHitCounter temp = new EntityHitCounter(firstRowType);
            if ((temp = (EntityHitCounter)counters.get(counters.indexOf(temp))).getCount() != 1) continue;
            ++mightHaveHeaderCounter;
        }
        return mightHaveHeaderCounter > 1;
    }

    private boolean performLastDitchEffortToFindHeader(List<List<Object>> tableData) {
        if (tableData.size() < 4) {
            return false;
        }
        List<Object> firstRow = tableData.get(0);
        int someChanceCounter = 0;
        int goodChanceCounter = 0;
        for (int i = 0; i < firstRow.size(); ++i) {
            int diff;
            int min = Integer.MAX_VALUE;
            int max = 0;
            int sum = 0;
            Object get = firstRow.get(i);
            boolean onlyFirstRowEmptyCheck = get == null;
            String firstRowValue = onlyFirstRowEmptyCheck ? "" : get.toString();
            boolean startsWithUpper = StringUtilities.startsWithUpper((String)firstRowValue);
            boolean dataNumericExceedsAlpha = StringUtilities.countLetters((String)firstRowValue) > StringUtilities.countNumbers((String)firstRowValue);
            boolean dataAlphaExceedsNumeric = StringUtilities.countLetters((String)firstRowValue) < StringUtilities.countNumbers((String)firstRowValue);
            boolean charDataCheck = StringUtilities.countChars((String)firstRowValue, (char[])this.charDataCheckArr) == 0;
            for (int k = 1; k < tableData.size(); ++k) {
                String dataField;
                List<Object> row = tableData.get(k);
                if (i >= row.size()) continue;
                Object dataGet = row.get(i);
                String string = dataField = dataGet == null ? "" : dataGet.toString();
                if (onlyFirstRowEmptyCheck && dataGet == null) {
                    onlyFirstRowEmptyCheck = false;
                }
                if (startsWithUpper && StringUtilities.startsWithUpper((String)dataField)) {
                    startsWithUpper = false;
                }
                if (dataNumericExceedsAlpha && StringUtilities.countLetters((String)dataField) > StringUtilities.countNumbers((String)dataField)) {
                    dataNumericExceedsAlpha = false;
                }
                if (dataAlphaExceedsNumeric && StringUtilities.countLetters((String)dataField) < StringUtilities.countNumbers((String)dataField)) {
                    dataAlphaExceedsNumeric = false;
                }
                if (charDataCheck && StringUtilities.countChars((String)dataField, (char[])this.charDataCheckArr) == 0) {
                    charDataCheck = false;
                }
                int length = dataField.length();
                sum += length;
                if (length < min) {
                    min = length;
                }
                if (length <= max) continue;
                max = length;
            }
            if (onlyFirstRowEmptyCheck) {
                ++goodChanceCounter;
            }
            if (startsWithUpper) {
                ++someChanceCounter;
            }
            if (dataAlphaExceedsNumeric || dataNumericExceedsAlpha) {
                ++goodChanceCounter;
            }
            if (charDataCheck) {
                ++goodChanceCounter;
            }
            if ((diff = max - min) < 3) {
                diff = 3;
            }
            int ave = sum / (tableData.size() - 1);
            min = ave - diff;
            max = ave + diff;
            int firstRowLength = firstRowValue.length();
            if (firstRowLength >= min && firstRowLength <= max) continue;
            ++goodChanceCounter;
        }
        return 1.0 < (double)goodChanceCounter + (double)someChanceCounter * 0.5;
    }

    private void putEntityWithProperties(String entitySpecName, List<Object> row, List<Integer> columns) {
        ArrayList<Integer> colsWithProps = new ArrayList<Integer>();
        ArrayList<PropertyDescriptor> colProps = new ArrayList<PropertyDescriptor>();
        for (int column : columns) {
            PropertyDescriptor property = this.getProperty(entitySpecName, row.get(column).toString());
            if (property == null || colProps.contains(property)) continue;
            colsWithProps.add(column);
            colProps.add(property);
            this.map.put(column, entitySpecName);
        }
        if (!colsWithProps.isEmpty()) {
            int[] cols = new int[colsWithProps.size()];
            for (int i = 0; i < colsWithProps.size(); ++i) {
                cols[i] = (Integer)colsWithProps.get(i);
            }
            PropertyDescriptor[] props = new PropertyDescriptor[colProps.size()];
            for (int i = 0; i < colProps.size(); ++i) {
                props[i] = (PropertyDescriptor)colProps.get(i);
            }
            this.tg.putEntityWithProperty(entitySpecName, cols, props);
        }
    }

    private PropertyDescriptor getProperty(String typeName, String propertyName) {
        EntityRegistry registry = EntityRegistry.getDefault();
        int firstIndex = propertyName.indexOf("#");
        int lastIndex = propertyName.lastIndexOf("=");
        if (firstIndex < 0) {
            return InheritanceHelper.getValueProperty((SpecRegistry)registry, (String)typeName);
        }
        propertyName = lastIndex < 0 ? propertyName.substring(firstIndex + 1) : propertyName.substring(firstIndex + 1, lastIndex);
        for (DisplayDescriptor dd : InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)typeName)) {
            if (!propertyName.equalsIgnoreCase(dd.getName())) continue;
            return dd;
        }
        return null;
    }

    private void putEntity(String entitySpecName, int ... columns) {
        for (int column : columns) {
            this.map.put(column, entitySpecName);
        }
        this.tg.putEntity(entitySpecName, columns);
    }

    private boolean hasColumnBeenMapped(int col) {
        return this.map.containsKey(col);
    }

    private String getDisplayString(String typeName) {
        EntityRegistry registry = EntityRegistry.getDefault();
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
        Optional dispExprOpt = InheritanceHelper.getDisplayValueExpression((SpecRegistry)registry, (String)typeName);
        if (dispExprOpt.isPresent()) {
            DisplayDescriptor dvp;
            String dispExpr = (String)dispExprOpt.get();
            if (spec != null && (dvp = spec.getProperties().get(dispExpr)) != null) {
                return dvp.getDisplayName();
            }
            return dispExpr;
        }
        return null;
    }
}

