/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.api.ViewletSerializer;
import com.paterva.maltego.view.customization.ui.ViewletRegistry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class DefaultViewletRegistry
extends ViewletRegistry {
    private static final boolean DEBUG = false;
    private static final String VIEWLETS_FOLDER = "Maltego/Viewlets/";
    private static final String EXT = "mtvs";
    private static final String ATTR_READ_ONLY = "readonly";
    private static final String ATTR_IN_TOOLBAR = "inToolbar";
    private static final String ATTR_IN_MENU = "inMenu";
    private static final String ATTR_ICON = "icon";
    private static final boolean BOOL_DEFAULT = false;
    private Map<String, Set<Viewlet>> _viewlets;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public DefaultViewletRegistry() {
        System.setProperty("polyglot.js.nashorn-compat", "true");
    }

    public DefaultViewletRegistry(FileObject configRoot) {
        super(configRoot);
    }

    @Override
    public Set<Viewlet> getAll(String viewID) {
        Set<Viewlet> viewlets = this.getViewlets(viewID);
        return Collections.unmodifiableSet(viewlets);
    }

    @Override
    public Map<String, Set<Viewlet>> getAll() {
        if (this._viewlets == null) {
            this._viewlets = this.load();
        }
        return this._viewlets;
    }

    private Set<Viewlet> getViewlets(String viewID) {
        Set<Viewlet> viewlets = this.getAll().get(viewID);
        if (viewlets == null) {
            viewlets = new HashSet<Viewlet>();
            this.getAll().put(viewID, viewlets);
        }
        return viewlets;
    }

    @Override
    public void setAll(String viewID, Set<Viewlet> viewlets) {
        this.removeMissing(viewID, viewlets);
        Set<Viewlet> newViewlets = this.updateModified(viewID, viewlets);
        this.addNew(viewID, newViewlets);
        this.getViewlets(viewID).clear();
        this.getViewlets(viewID).addAll(viewlets);
        this._changeSupport.firePropertyChange(viewID, null, null);
    }

    @Override
    public void addListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private Map<String, Set<Viewlet>> load() {
        HashMap<String, Set<Viewlet>> viewletsPerView = new HashMap<String, Set<Viewlet>>();
        try {
            FileObject folder = this.getFolder();
            if (folder != null) {
                for (FileObject folderObject : folder.getChildren()) {
                    if (!folderObject.isFolder()) continue;
                    Set<Viewlet> viewlets = this.load(folderObject);
                    viewletsPerView.put(folderObject.getName(), viewlets);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return viewletsPerView;
    }

    private Set<Viewlet> load(FileObject folder) {
        HashSet<Viewlet> viewlets = new HashSet<Viewlet>();
        try {
            for (FileObject fileObject : folder.getChildren()) {
                Viewlet viewlet;
                if (fileObject.isFolder() || !EXT.equals(fileObject.getExt()) || (viewlet = this.load(folder.getName(), fileObject)) == null) continue;
                viewlet.setReadOnly(this.getBoolAttr(fileObject, ATTR_READ_ONLY, false));
                viewlet.setInToolbar(this.getBoolAttr(fileObject, ATTR_IN_TOOLBAR, false));
                viewlet.setInMenu(this.getBoolAttr(fileObject, ATTR_IN_MENU, false));
                viewlet.setIcon(this.getStrAttr(fileObject, ATTR_ICON));
                viewlets.add(viewlet);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return viewlets;
    }

    private String getStrAttr(FileObject fileObject, String attr) {
        String value = null;
        Object obj = fileObject.getAttribute(attr);
        if (obj instanceof String) {
            value = (String)obj;
        }
        return value;
    }

    private boolean getBoolAttr(FileObject fileObject, String attr, boolean def) {
        boolean value = def;
        Object obj = fileObject.getAttribute(attr);
        if (obj instanceof Boolean) {
            value = (Boolean)obj;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Viewlet load(String viewID, FileObject fileObject) throws IOException {
        Viewlet viewlet = null;
        try (InputStream inputStream = null;){
            inputStream = fileObject.getInputStream();
            viewlet = ViewletSerializer.getDefault().read(viewID, inputStream);
        }
        return viewlet;
    }

    private void removeMissing(String viewID, Set<Viewlet> viewlets) {
        try {
            FileObject folder = this.getFolder(viewID);
            for (FileObject fileObject : folder.getChildren()) {
                Viewlet saved;
                if (!EXT.equals(fileObject.getExt()) || viewlets.contains(saved = this.load(viewID, fileObject))) continue;
                this.debugLog("Remove: " + fileObject);
                fileObject.delete();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Set<Viewlet> updateModified(String viewID, Set<Viewlet> viewlets) {
        HashSet<Viewlet> newViewlets = new HashSet<Viewlet>(viewlets);
        try {
            FileObject folder = this.getFolder(viewID);
            for (FileObject fileObject : folder.getChildren()) {
                if (!EXT.equals(fileObject.getExt())) continue;
                Viewlet saved = this.load(viewID, fileObject);
                for (Viewlet viewlet : viewlets) {
                    if (!saved.equals(viewlet)) continue;
                    if (this.isBindingsModified(saved, viewlet)) {
                        this.debugLog("Update: " + fileObject);
                        this.update(viewID, viewlet, fileObject);
                    } else {
                        this.debugLog("Is up to date: " + fileObject);
                    }
                    this.updateAttributes(fileObject, viewlet);
                    newViewlets.remove(viewlet);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return newViewlets;
    }

    private boolean isBindingsModified(Viewlet oldC, Viewlet newC) {
        return !oldC.hasSimilarBindings(newC);
    }

    private void updateAttributes(FileObject fileObject, Viewlet viewlet) throws IOException {
        this.updateAttribute(fileObject, ATTR_IN_TOOLBAR, viewlet.isInToolbar());
        this.updateAttribute(fileObject, ATTR_IN_MENU, viewlet.isInMenu());
        this.updateAttribute(fileObject, ATTR_ICON, viewlet.getIcon());
    }

    private void updateAttribute(FileObject fileObject, String attr, Object newValue) throws IOException {
        Object oldValue = fileObject.getAttribute(attr);
        if (!Utilities.compareObjects((Object)oldValue, (Object)newValue)) {
            fileObject.setAttribute(attr, newValue);
        }
    }

    private void addNew(String viewID, Set<Viewlet> viewlets) {
        try {
            FileObject folder = this.getFolder(viewID);
            for (Viewlet viewlet : viewlets) {
                this.save(viewID, viewlet, folder);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String viewID, Viewlet viewlet, FileObject folder) throws IOException {
        String name = viewlet.getName();
        FileObject file = FileUtilities.createUniqueFile((FileObject)folder, (String)FileUtilities.replaceIllegalChars((String)name), (String)EXT);
        try (OutputStream outputStream = null;){
            this.debugLog("Add new: " + file);
            outputStream = new BufferedOutputStream(file.getOutputStream());
            ViewletSerializer.getDefault().write(viewID, viewlet, outputStream);
            this.updateAttributes(file, viewlet);
        }
    }

    private void update(String viewID, Viewlet viewlet, FileObject file) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(file.getOutputStream());){
            ViewletSerializer.getDefault().write(viewID, viewlet, (OutputStream)outputStream);
        }
    }

    private FileObject getFolder() throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)VIEWLETS_FOLDER);
    }

    private FileObject getFolder(String viewID) throws IOException {
        return FileUtilities.getOrCreate((FileObject)this._configRoot, (String)(VIEWLETS_FOLDER + viewID));
    }

    private void debugLog(String text) {
    }
}

