/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.paterva.maltego.ui.graph.impl.GraphViewFactory;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

class GraphOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    public GraphOpenSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    protected String messageOpened() {
        return "Opened";
    }

    protected String messageOpening() {
        return "Opening...";
    }

    protected GraphDataObject getGraphDataObject() {
        return (GraphDataObject)this.entry.getDataObject();
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent tc;
        if (!this.entry.getDataObject().isTemplate()) {
            RecentFiles.getInstance().addFile(this.entry.getFile().toURL().toString());
        }
        if ((tc = GraphViewFactory.createViews((DataObject)this.entry.getDataObject(), new CloseHandler())) != null) {
            tc.putClientProperty((Object)"selection", (Object)"always");
            tc.setHtmlDisplayName(this.getGraphDataObject().getHTMLDisplayName());
            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("MaltegoDetailViewsGroup");
            if (group != null) {
                group.open();
            }
            return tc;
        }
        return null;
    }

    protected boolean canClose() {
        return !this.entry.getDataObject().isModified();
    }

    protected boolean close(boolean ask) {
        boolean closed = super.close(ask);
        if (closed) {
            this.entry.getDataObject().setModified(false);
        }
        return closed;
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CloseHandler() {
        }

        public boolean resolveCloseOperation(CloseOperationState[] elements) {
            String save = "Save";
            String dontSave = "Don't Save";
            String cancel = "Cancel";
            LinkedList<CloseOperationState> e2 = new LinkedList<CloseOperationState>(Arrays.asList(elements));
            while (!e2.isEmpty()) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)"Do you want to save your changes to the graph?", "Maltego", 1, 2, new Object[]{save, dontSave, cancel}, (Object)save);
                DialogDisplayer.getDefault().notify(nd);
                if (nd.getValue().equals(save)) {
                    Iterator it = e2.iterator();
                    while (it.hasNext()) {
                        CloseOperationState element = (CloseOperationState)it.next();
                        Action proceedAction = element.getProceedAction();
                        proceedAction.actionPerformed(new ActionEvent(this, 1001, "dirty"));
                        if (proceedAction.isEnabled()) continue;
                        it.remove();
                    }
                    continue;
                }
                if (nd.getValue().equals(dontSave)) {
                    for (CloseOperationState element : elements) {
                        element.getDiscardAction().actionPerformed(new ActionEvent(this, 1001, "dirty"));
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

