/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.structure;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.pinkmatter.pandora.Artifact;
import java.util.HashSet;
import java.util.Set;

public class StructureArtifactUtils {
    public static EntityID getSource(Artifact linkArtifact) {
        return StructureArtifactUtils.getEntity(linkArtifact, "source");
    }

    public static EntityID getTarget(Artifact linkArtifact) {
        return StructureArtifactUtils.getEntity(linkArtifact, "target");
    }

    public static EntityID getEntity(Artifact linkArtifact, String side) {
        Long longID = (Long)linkArtifact.get(side);
        return EntityID.create((long)longID);
    }

    public static Set<LinkID> getLinks(Artifact entityArtifact) {
        Set<LinkID> links = StructureArtifactUtils.getIncoming(entityArtifact);
        links.addAll(StructureArtifactUtils.getOutgoing(entityArtifact));
        return links;
    }

    public static Set<LinkID> getIncoming(Artifact entityArtifact) {
        return StructureArtifactUtils.getLinks(entityArtifact, "in");
    }

    public static Set<LinkID> getOutgoing(Artifact entityArtifact) {
        return StructureArtifactUtils.getLinks(entityArtifact, "out");
    }

    public static Set<Long> getLinksLong(Artifact entityArtifact) {
        Set<Long> links = StructureArtifactUtils.getIncomingLong(entityArtifact);
        links.addAll(StructureArtifactUtils.getOutgoingLong(entityArtifact));
        return links;
    }

    public static Set<Long> getIncomingLong(Artifact entityArtifact) {
        return StructureArtifactUtils.getLinksLong(entityArtifact, "in");
    }

    public static Set<Long> getOutgoingLong(Artifact entityArtifact) {
        return StructureArtifactUtils.getLinksLong(entityArtifact, "out");
    }

    public static Set<LinkID> getLinks(Artifact entityArtifact, String direction) {
        Set<Long> linksLong = StructureArtifactUtils.getLinksLong(entityArtifact, direction);
        HashSet<LinkID> linkIDs = new HashSet<LinkID>(linksLong.size());
        for (Long longID : linksLong) {
            linkIDs.add(LinkID.create((long)longID));
        }
        return linkIDs;
    }

    public static int getLinkCount(Artifact entityArtifact, String direction) {
        Object obj = entityArtifact.get(direction);
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            long[] longIDs = (long[])obj;
            return longIDs.length;
        }
        return 1;
    }

    public static Set<Long> getLinksLong(Artifact entityArtifact, String direction) {
        HashSet<Long> linkIDs;
        Object obj = entityArtifact.get(direction);
        if (obj == null) {
            linkIDs = new HashSet<Long>(1);
        } else if (obj.getClass().isArray()) {
            long[] longIDs = (long[])obj;
            linkIDs = new HashSet(longIDs.length);
            for (long longID : longIDs) {
                linkIDs.add(longID);
            }
        } else {
            linkIDs = new HashSet(1);
            linkIDs.add((Long)obj);
        }
        return linkIDs;
    }
}

