/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications;

import com.paterva.maltego.notifications.ServerNotificationActionHandler;
import com.paterva.maltego.notifications.data.ServerNotification;
import com.paterva.maltego.notifications.data.ServerNotificationButton;
import com.paterva.maltego.util.ui.components.SmoothScrollingEditorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.net.URL;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;

public class ServerNotificationDisplayer {
    public void show(List<ServerNotification> notifications) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must be called in EDT");
        }
        notifications.forEach(this::show);
    }

    public void show(ServerNotification notification) {
        DialogDescriptor descriptor = this.createDialogDescriptor(notification);
        DialogDisplayer displayer = DialogDisplayer.getDefault();
        Dialog dialog = displayer.createDialog(descriptor);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        ServerNotificationButton buttonPressed = (ServerNotificationButton)descriptor.getValue();
        ServerNotificationActionHandler handler = new ServerNotificationActionHandler();
        handler.handle(notification, buttonPressed);
    }

    private DialogDescriptor createDialogDescriptor(ServerNotification notification) {
        String title = notification.getTitle();
        boolean modal = true;
        JScrollPane scrollPane = this.createComponent(notification);
        DialogDescriptor descriptor = new DialogDescriptor((Object)scrollPane, title, modal, null);
        Object[] buttons = this.getButtons(notification);
        descriptor.setOptions(buttons);
        descriptor.setNoDefaultClose(true);
        return descriptor;
    }

    private JScrollPane createComponent(ServerNotification notification) {
        SmoothScrollingEditorPane editorPane = new SmoothScrollingEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.setText(notification.getContent().getTextPlain().orElse("<Notification Text Empty>"));
        editorPane.setCaretPosition(0);
        editorPane.addHyperlinkListener(evt -> {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = evt.getURL();
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        });
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)editorPane);
        viewPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        notification.getWidth().ifPresent(width -> notification.getHeight().ifPresent(height -> viewPanel.setPreferredSize(new Dimension((int)width, (int)height))));
        JScrollPane scrollPane = new JScrollPane(viewPanel);
        return scrollPane;
    }

    private ServerNotificationButton[] getButtons(ServerNotification notification) {
        return notification.getButtons().toArray(new ServerNotificationButton[0]);
    }
}

