/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    public static final String IN_HUB_PANEL = "inHubPanel";

    public static ComponentUI createUI(JComponent c) {
        if (UIUtil.getParentOfType(CellRendererPane.class, c) != null) {
            c.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (preferredSize.width > 0 && (SystemInfo.isLinux || SystemInfo.isWindows)) {
            preferredSize.width += 10;
        }
        return preferredSize;
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        JCheckBox b = (JCheckBox)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font font = b.getFont();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap() - 3);
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (b.isSelected() && b.getSelectedIcon() != null) {
            b.getSelectedIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else if (!b.isSelected() && b.getIcon() != null) {
            b.getIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else {
            int x = iconRect.x;
            int y = iconRect.y + 3;
            int w = iconRect.width - 6;
            int h = iconRect.height - 6;
            g.translate(x, y);
            GradientPaint paint = new GradientPaint(w / 2, 0.0f, b.getBackground().brighter(), w / 2, h, b.getBackground());
            g.setPaint(paint);
            g.fillRect(1, 1, w - 2, h - 2);
            GraphicsConfig config = new GraphicsConfig(g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            boolean armed = b.getModel().isArmed();
            if (DarculaCheckBoxUI.isInHubPanel(c)) {
                if (b.getModel().isSelected() || b.getModel().isRollover()) {
                    g.setColor(DarculaCheckBoxUI.getSelectedBackgroundColorHub());
                } else {
                    g.setColor(DarculaCheckBoxUI.getBackgroundColorHub());
                }
                g.drawRect(0, 0, w, h - 1);
            } else if (c.hasFocus()) {
                g.setPaint(new GradientPaint(w / 2, 1.0f, DarculaCheckBoxUI.getFocusedBackgroundColor1(armed), w / 2, h, DarculaCheckBoxUI.getFocusedBackgroundColor2(armed)));
            } else {
                g.setPaint(new GradientPaint(w / 2, 1.0f, DarculaCheckBoxUI.getBackgroundColor1(), w / 2, h, DarculaCheckBoxUI.getBackgroundColor2()));
            }
            g.fillRect(0, 0, w, h - 1);
            if (b.getModel().isSelected()) {
                if (DarculaCheckBoxUI.isInHubPanel(c)) {
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g.setStroke(new BasicStroke(2.0f, 1, 1));
                    g.setPaint(DarculaCheckBoxUI.getCheckSignColorHub());
                    g.drawLine(3, 7, 6, 10);
                    g.drawLine(6, 10, w - 2, 4);
                } else {
                    g.setPaint(DarculaCheckBoxUI.getBorderSelectedColor(b.isEnabled()));
                    g.drawRect(0, 0, w, h - 1);
                    g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    g.setStroke(new BasicStroke(2.0f, 1, 1));
                    g.setPaint(DarculaCheckBoxUI.getCheckSignColor(b.isEnabled()));
                    g.drawLine(4, 5, 7, 9);
                    g.drawLine(7, 9, w, 0);
                }
            } else {
                if (DarculaCheckBoxUI.isInHubPanel(c)) {
                    if (b.getModel().isRollover()) {
                        g.setColor(DarculaCheckBoxUI.getSelectedBackgroundColorHub());
                    } else {
                        g.setColor(DarculaCheckBoxUI.getBackgroundColorHub());
                    }
                } else {
                    g.setPaint(DarculaCheckBoxUI.getBorderColor(b.isEnabled()));
                }
                g.drawRect(0, 0, w, h - 1);
            }
            g.translate(-x, -y);
            config.restore();
        }
        if (text != null) {
            GraphicsUtil.setupTextAntialiasing(g, c);
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                g.setColor(model.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, b.getDisplayedMnemonicIndex(), textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    public static Color getBorderSelectedColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderSelectedColor", Gray._40.withAlpha(180)) : DarculaCheckBoxUI.getColor("borderDisabledColor", Gray._100);
    }

    public static Color getBorderColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor", Gray._40.withAlpha(180)) : DarculaCheckBoxUI.getColor("borderDisabledColor", Gray._100);
    }

    protected Color getInactiveFillColor() {
        return DarculaCheckBoxUI.getColor("inactiveFillColor", Gray._40.withAlpha(180));
    }

    protected Color getActiveFillColor() {
        return DarculaCheckBoxUI.getColor("activeFillColor", Gray._40.withAlpha(180));
    }

    protected Color getBorderColor1(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor1", Gray._120.withAlpha(90)) : DarculaCheckBoxUI.getColor("disabledBorderColor1", Gray._120.withAlpha(90));
    }

    protected Color getBorderColor2(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor2", Gray._105.withAlpha(90)) : DarculaCheckBoxUI.getColor("disabledBorderColor2", Gray._105.withAlpha(90));
    }

    private static boolean isInHubPanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HUB_PANEL));
    }

    public static Color getBackgroundColor1() {
        return DarculaCheckBoxUI.getColor("backgroundColor1", Gray._110);
    }

    public static Color getBackgroundColor2() {
        return DarculaCheckBoxUI.getColor("backgroundColor2", Gray._95);
    }

    private static Color getSelectedBackgroundColorHub() {
        return DarculaCheckBoxUI.getColor("selectedBackgroundColorHub", Gray._95);
    }

    private static Color getBackgroundColorHub() {
        return DarculaCheckBoxUI.getColor("backgroundColorHub", Gray._95);
    }

    public static Color getCheckSignColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("checkSignColor", Gray._170) : DarculaCheckBoxUI.getColor("checkSignColorDisabled", Gray._120);
    }

    public static Color getCheckSignColorHub() {
        return DarculaCheckBoxUI.getColor("checkSignColorHub", Color.RED);
    }

    protected Color getShadowColor(boolean enabled) {
        return enabled ? DarculaCheckBoxUI.getColor("shadowColor", Gray._30) : DarculaCheckBoxUI.getColor("shadowColorDisabled", Gray._60);
    }

    public static Color getFocusedBackgroundColor1(boolean armed) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor1", Gray._100) : DarculaCheckBoxUI.getColor("focused.backgroundColor1", Gray._120);
    }

    public static Color getFocusedBackgroundColor2(boolean armed) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor2", Gray._55) : DarculaCheckBoxUI.getColor("focused.backgroundColor2", Gray._75);
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue) {
        Color color = UIManager.getLookAndFeelDefaults().getColor("CheckBox.darcula." + shortPropertyName);
        if (color == null) {
            System.err.println(shortPropertyName + " color = null");
        }
        return color;
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

