/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.actions.userfilter.EntityNodeHelper;
import com.paterva.maltego.automation.actions.userfilter.EntityNodeToEntitySpecConverter;
import com.paterva.maltego.automation.actions.userfilter.EntityNodeToMaltegoEntityConverter;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import com.paterva.maltego.ui.graph.nodes.NodeConverterKey;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class EntityNode
extends AbstractNode {
    private final GraphID _graphID;
    private final EntityID _entityID;
    private boolean _selected = true;

    public EntityNode(GraphID graphID, EntityID entityID) {
        this(graphID, entityID, new InstanceContent());
    }

    protected EntityNode(GraphID graphID, EntityID entityID, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._graphID = graphID;
        this._entityID = entityID;
        content.add((Object)entityID);
        content.add((Object)graphID);
        content.add((Object)new CheckSupport());
        content.add((Object)new NodeConverterKey((Node)this), (InstanceContent.Convertor)EntityNodeToMaltegoEntityConverter.instance());
        content.add((Object)new NodeConverterKey((Node)this), (InstanceContent.Convertor)EntityNodeToEntitySpecConverter.instance());
        content.add((Object)new GraphEntity(this._graphID, this._entityID));
    }

    public GraphID getGraphID() {
        return this._graphID;
    }

    public EntityID getEntityID() {
        return this._entityID;
    }

    public Image getIcon(int type) {
        return EntityImageFactory.forGraph((GraphID)this._graphID).getImage(this.getEntity(), -1, this.getSize(type), null);
    }

    public MaltegoEntity getEntity() {
        return GraphStoreHelper.getEntity((GraphID)this._graphID, (EntityID)this._entityID);
    }

    public String getEntityType() {
        String type = null;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            type = dataReader.getEntityType(this._entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return type;
    }

    public MaltegoEntitySpec getEntitySpec() {
        String type = this.getEntityType();
        EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._graphID);
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(type);
        return spec;
    }

    private EntityRegistry getRegistry() {
        return EntityRegistry.forGraphID((GraphID)this._graphID);
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    public String getDisplayName() {
        return InheritanceHelper.getDisplayString((SpecRegistry)this.getRegistry(), (TypedPropertyBag)this.getEntity());
    }

    public Action getPreferredAction() {
        return new NavigateToViewAction();
    }

    public Transferable clipboardCopy() throws IOException {
        return super.clipboardCopy();
    }

    public Action[] getActions(boolean popup) {
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        Sheet.Set defaultSet = sheet.get("");
        defaultSet.put((Node.Property)new EntityProperties.Type((Node)this));
        defaultSet.put((Node.Property)new EntityProperties.IncomingLinks((Node)this));
        defaultSet.put((Node.Property)new EntityProperties.OutgoingLinks((Node)this));
        sheet.put(defaultSet);
        return sheet;
    }

    public String toString() {
        return InheritanceHelper.getDisplayString((SpecRegistry)this.getRegistry(), (TypedPropertyBag)this.getEntity());
    }

    private class NavigateToViewAction
    extends AbstractAction {
        public NavigateToViewAction() {
            super("Navigate to");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaltegoEntity entity = EntityNode.this.getEntity();
            if (entity != null) {
                EntityNodeHelper.navigateTo((EntityID)entity.getID());
            }
        }
    }

    private class CheckSupport
    implements CheckableNode {
        private CheckSupport() {
        }

        public boolean isCheckable() {
            return true;
        }

        public boolean isCheckEnabled() {
            return true;
        }

        public Boolean isSelected() {
            return EntityNode.this._selected;
        }

        public void setSelected(Boolean value) {
            if (EntityNode.this._selected != value) {
                EntityNode.this._selected = value;
                EntityNode.this.fireIconChange();
            }
        }
    }
}

