/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class RowTableModel<T>
extends AbstractTableModel {
    private List<T> _data;
    private String[] _columnNames;
    private Class[] _columnClasses;
    private boolean[] _colEditable;
    private boolean _editable = true;

    protected RowTableModel(String[] columnNames) {
        this(columnNames, new ArrayList());
    }

    protected RowTableModel(String[] columnNames, List<T> data) {
        this._data = data;
        this._columnNames = columnNames;
        this._columnClasses = new Class[columnNames.length];
        this._colEditable = new boolean[columnNames.length];
        Arrays.fill(this._columnClasses, Object.class);
    }

    public Class getColumnClass(int column) {
        if (column < this._columnClasses.length) {
            return this._columnClasses[column];
        }
        return Object.class;
    }

    public void setColumnClass(int column, Class columnClass) {
        this._columnClasses[column] = columnClass;
        this.fireTableRowsUpdated(0, this.getColumnCount() - 1);
    }

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        if (column < this._columnNames.length) {
            return this._columnNames[column];
        }
        return "No such column";
    }

    @Override
    public int getRowCount() {
        return this._data.size();
    }

    public void setColumnEditable(int column, boolean isEditable) {
        this._colEditable[column] = isEditable ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this._editable) {
            return false;
        }
        if (column < this._colEditable.length) {
            return this._colEditable[column];
        }
        return false;
    }

    public void addRow(T rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    public void insertRow(int row, T rowData) {
        this._data.add(row, rowData);
        this.fireTableRowsInserted(row, row);
    }

    public T getRow(int row) {
        return this._data.get(row);
    }

    public List<T> getRows() {
        return this._data;
    }

    public void setRows(List<T> rows) {
        this._data = rows;
        this.fireTableStructureChanged();
    }

    public List<T> getRows(int[] rowIndices) {
        ArrayList<T> list = new ArrayList<T>(rowIndices.length);
        for (int index : rowIndices) {
            list.add(this.getRow(index));
        }
        return list;
    }

    public void setEditable(boolean value) {
        this._editable = value;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public abstract Object getValueFor(T var1, int var2);

    public void setValueFor(T row, int column, Object value) {
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T data = this.getRow(rowIndex);
        return this.getValueFor(data, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            T data = this.getRow(rowIndex);
            this.setValueFor(data, columnIndex, aValue);
        }
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        if (start < 0) {
            String message = "Start index must be positive: " + start;
            throw new IllegalArgumentException(message);
        }
        if (end > this.getRowCount() - 1) {
            String message = "End index must be less than total rows: " + end;
            throw new IllegalArgumentException(message);
        }
        if (start > end) {
            String message = "Start index cannot be greater than end index";
            throw new IllegalArgumentException(message);
        }
        int rowsMoved = end - start + 1;
        if (to < 0 || to > this.getRowCount() - rowsMoved) {
            String message = "New destination row (" + to + ") is invalid";
            throw new IllegalArgumentException(message);
        }
        ArrayList<T> temp = new ArrayList<T>(rowsMoved);
        for (int i = start; i < end + 1; ++i) {
            temp.add(this._data.get(i));
        }
        this._data.subList(start, end + 1).clear();
        this._data.addAll(to, temp);
        if (to < start) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        this.fireTableRowsUpdated(first, last);
    }

    public void removeRowRange(int start, int end) {
        this._data.subList(start, end + 1).clear();
        this.fireTableRowsDeleted(start, end);
    }

    public void removeRow(int index) {
        this._data.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeRows(int[] indices) {
        int smallest = Integer.MAX_VALUE;
        int largest = -1;
        LinkedList<T> temp = new LinkedList<T>();
        for (int i = 0; i < indices.length; ++i) {
            smallest = Math.min(smallest, indices[i]);
            largest = Math.max(largest, indices[i]);
            temp.add(this._data.get(indices[i]));
        }
        this._data.removeAll(temp);
        this.fireTableRowsDeleted(smallest, largest);
    }

    public void replaceRow(int row, T rowData) {
        this._data.set(row, rowData);
        this.fireTableRowsUpdated(row, row);
    }
}

