/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.privacymode;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.components.ComboBoxToolTipRenderer;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.components.TransparentPanel;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class PrivacyModeComboBox
extends TransparentPanel {
    private static final String DESCRIPTION1 = "Privacy mode for certain web requests.";
    private static final String DESCRIPTION2 = "Hover over individual options for a description.";
    private static final String MAX_MODE_WIDTH;
    private JComboBox _combo;
    private final AtomicBoolean _wizard = new AtomicBoolean(false);
    private final AtomicBoolean _allowComboActions = new AtomicBoolean(true);
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private PrivacyMode _comboSelectedItem = null;
    private PrivacyModeListener _modeListener;

    public PrivacyModeComboBox(boolean wizard) {
        this._wizard.set(wizard);
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._modeListener = new PrivacyModeListener();
        PrivacyModeSettings.getInstance().addPropertyChangeListener(this._modeListener);
    }

    @Override
    public void removeNotify() {
        PrivacyModeSettings.getInstance().removePropertyChangeListener(this._modeListener);
        this._modeListener = null;
        super.removeNotify();
    }

    private void initComponents() {
        this._allowComboActions.set(false);
        this._combo = new JComboBox();
        ComboBoxToolTipRenderer renderer = new ComboBoxToolTipRenderer();
        this._combo.setRenderer(renderer);
        this._combo.setToolTipText("Privacy mode for certain web requests. Hover over individual options for a description.");
        this._combo.setPreferredSize(this.getPreferredComboDimension());
        this._combo.setEditable(false);
        this._combo.setModel(new DefaultComboBoxModel<PrivacyMode>(PrivacyMode.values()));
        ArrayList<String> tooltips = new ArrayList<String>();
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        for (PrivacyMode privacyMode : PrivacyMode.values()) {
            tooltips.add(privacyMode.getShortDescription());
            icons.add(privacyMode.getIcon().orElse(null));
        }
        renderer.setTooltips(tooltips);
        renderer.setIcons(icons);
        this._combo.addItemListener(evt -> {
            if (!this._updating.get()) {
                this.comboItemStateChanged(evt);
            }
        });
        this._combo.setSelectedIndex(-1);
        this._comboSelectedItem = this.getPrivacyMode();
        this._combo.setSelectedItem((Object)this._comboSelectedItem);
        if (this._wizard.get()) {
            JEditorPane editorPane = new JEditorPane();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(21);
            editorPane.setEditable(false);
            editorPane.setContentType("text/html");
            String description = "";
            for (PrivacyMode mode : PrivacyMode.values()) {
                description = description + "<strong>" + mode.getDisplayName() + " Privacy Mode:</strong>  " + mode.getLongDescription() + "<br><br>";
            }
            String string = "<html><head></head><body><p style=\"margin-top: 0; font-size: 9px\">" + description + "</p></body></html>";
            editorPane.setText(string);
            scrollPane.setViewportView(editorPane);
            JPanel comboContainer = new JPanel();
            comboContainer.setLayout(new GridBagLayout());
            LabelWithBackground _statusLabel = new LabelWithBackground("Privacy Mode ");
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(6, 6, 6, 0), 0, 0);
            comboContainer.add((Component)_statusLabel, gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(6, 0, 6, 6), this._combo.getPreferredSize().width, 0);
            comboContainer.add((Component)this._combo, gbc);
            gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
            comboContainer.add((Component)new JPanel(), gbc);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(comboContainer).addGap(0, 122, Short.MAX_VALUE)))));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(comboContainer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane, -1, 200, Short.MAX_VALUE)));
        } else {
            TransparentPanel comboPanel = new TransparentPanel();
            comboPanel.add(this._combo);
            comboPanel.setBorder(new EmptyBorder(12, 0, 12, 0));
            JLabel label = new JLabel("Privacy Mode");
            label.setForeground(UIManager.getLookAndFeelDefaults().getColor("ribbon-button-text-color"));
            label.setHorizontalAlignment(0);
            this.add((Component)label, "North");
            this.add((Component)comboPanel, "Center");
        }
        this._allowComboActions.set(true);
    }

    PrivacyMode getPrivacyMode() {
        if (this._comboSelectedItem == null) {
            this._comboSelectedItem = PrivacyModeSettings.getInstance().getPrivacyMode();
        }
        return this._comboSelectedItem;
    }

    void setPrivacyMode(PrivacyMode mode) {
        if (!this._updating.get()) {
            this._combo.setSelectedItem((Object)mode);
        }
    }

    private Dimension getPreferredComboDimension() {
        Dimension comboPrefSize = this._combo.getPreferredSize();
        Graphics2D g2D = GraphicsUtils.createGraphics2D();
        Font font = this._combo.getFont();
        g2D.setFont(font);
        int width = (int)Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)MAX_MODE_WIDTH));
        g2D.dispose();
        return new Dimension(Math.max(comboPrefSize.width, width + 52 + font.getSize()), comboPrefSize.height);
    }

    private void comboItemStateChanged(ItemEvent evt) {
        if (this._allowComboActions.get() && evt.getStateChange() == 1) {
            PrivacyMode itemName;
            this._updating.set(true);
            this._comboSelectedItem = itemName = (PrivacyMode)((Object)evt.getItem());
            if (!this._wizard.get()) {
                PrivacyModeSettings.getInstance().setPrivacyMode(this._comboSelectedItem);
            }
            this._updating.set(false);
        }
    }

    static {
        String maxModeWidth = "";
        for (PrivacyMode value : PrivacyMode.values()) {
            if (maxModeWidth.length() >= value.getDisplayName().length()) continue;
            maxModeWidth = value.getDisplayName();
        }
        MAX_MODE_WIDTH = maxModeWidth;
    }

    private class PrivacyModeListener
    implements PropertyChangeListener {
        private PrivacyModeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PrivacyModeComboBox.this._comboSelectedItem != null && evt != null && evt.getPropertyName() != null) {
                switch (evt.getPropertyName()) {
                    case "PrivacyModeSet": {
                        Object newValue = evt.getNewValue();
                        if (!(newValue instanceof PrivacyMode)) break;
                        PrivacyMode newMode = (PrivacyMode)((Object)newValue);
                        if (PrivacyModeComboBox.this._comboSelectedItem == newMode) break;
                        PrivacyModeComboBox.this.setPrivacyMode(newMode);
                    }
                }
            }
        }
    }
}

