/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.actions;

import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.util.ui.actions.ActionSupplementals;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.openide.awt.ActionID;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedAnnotationTypes(value={"com.paterva.maltego.util.ui.actions.ActionSupplementals", "com.paterva.maltego.util.ui.actions.ActionSupplemental"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class ActionSupplementalsProcessor
extends LayerGeneratingProcessor {
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment env) throws LayerGenerationException {
        System.out.println("ActionSupplementalsProcessor");
        for (Element element : env.getElementsAnnotatedWith(ActionID.class)) {
            ActionID aid = element.getAnnotation(ActionID.class);
            if (aid == null) {
                throw new LayerGenerationException("@ActionSupplemental(s) can only be used together with @ActionID annotation", element);
            }
            if (aid.category().startsWith("Actions/")) {
                throw new LayerGenerationException("@ActionID category() cannot contain /", element);
            }
            String id = aid.id().replace('.', '-');
            LayerBuilder.File f = this.layer(new Element[]{element}).file("Actions/" + aid.category() + "/" + id + ".instance");
            ActionSupplementals asups = element.getAnnotation(ActionSupplementals.class);
            if (asups != null) {
                this.processSupplementals(element, asups, f);
                continue;
            }
            ActionSupplemental asup = element.getAnnotation(ActionSupplemental.class);
            if (asup == null) continue;
            this.processSupplemental(element, asup, f);
        }
        return true;
    }

    private void processSupplementals(Element e, ActionSupplementals sups, LayerBuilder.File f) throws LayerGenerationException {
        ActionSupplemental[] asups;
        for (ActionSupplemental asup : asups = sups.value()) {
            if (asup == null) continue;
            this.processSupplemental(e, asup, f);
        }
    }

    private void processSupplemental(Element e, ActionSupplemental sup, LayerBuilder.File f) throws LayerGenerationException {
        f.stringvalue(sup.key(), sup.value());
        f.write();
    }
}

