/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.finder.wizard.UpdateDisclaimerController;
import com.paterva.maltego.transform.finder.wizard.UpdateTransformsFetchController;
import com.paterva.maltego.transform.finder.wizard.UpdateTransformsInstallController;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public final class DiscoveryWizard {
    public static WizardDescriptor install(HubSeedDescriptor hubSeed, List<TransformSeed> seeds) {
        TransformSeed[] selectedSeeds = (TransformSeed[])seeds.stream().toArray(TransformSeed[]::new);
        ArrayList<Object> panels = new ArrayList<Object>();
        UpdateTransformsFetchController fetch = new UpdateTransformsFetchController();
        fetch.setName("Download");
        fetch.setDescription("Fetch Transforms");
        fetch.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
        panels.add((Object)fetch);
        UpdateDisclaimerController disclaimers = new UpdateDisclaimerController();
        disclaimers.setName("Terms & Conditions");
        disclaimers.setDescription("Accept Terms & Conditions to continue");
        disclaimers.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
        panels.add((Object)disclaimers);
        UpdateTransformsInstallController install = new UpdateTransformsInstallController();
        install.setName("Install");
        install.setDescription("Install Transforms and Entities");
        install.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
        panels.add((Object)install);
        WizardDescriptor.Panel[] panelArray = panels.toArray(new WizardDescriptor.Panel[panels.size()]);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panelArray));
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("hubItem", (Object)hubSeed);
        wizardDescriptor.putProperty("allTransformSeeds", seeds);
        wizardDescriptor.putProperty("transformSeeds", (Object)selectedSeeds);
        wizardDescriptor.putProperty("removeMissing", (Object)Boolean.TRUE);
        String displayName = seeds.isEmpty() ? null : seeds.get(0).getDisplayName();
        wizardDescriptor.setTitle("Install " + displayName);
        wizardDescriptor.setTitleFormat(new MessageFormat(displayName + " - {0} ({1})"));
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
        return wizardDescriptor;
    }
}

