/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.reset;

import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.welcome.home.HomeVsOtherWindowsSynchronizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;

@ActionSupplemental(key="description", value="Reset all windows to their initial states.")
public final class ResetWindowsAction
implements ActionListener {
    private static boolean _reset = false;

    public static boolean isReset() {
        return _reset;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resetWithRestart();
    }

    private void resetWithRestart() {
        String msg = "Are you sure you want to reset all windows? (Maltego will be restarted)";
        if (!this.showConfirmation(msg)) {
            return;
        }
        _reset = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LifecycleManager lifeCycleManager = LifecycleManager.getDefault();
                lifeCycleManager.markForRestart();
                lifeCycleManager.exit();
            }
        });
    }

    private boolean showConfirmation(String msg) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg);
        nd.setTitle("Reset Windows");
        nd.setMessageType(2);
        nd.setOptionType(1);
        return NotifyDescriptor.Confirmation.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
    }

    private void resetWithoutRestart(final ActionEvent e) throws IllegalArgumentException {
        HomeVsOtherWindowsSynchronizer.instance().setEnabled(false);
        final Action delegate = Actions.forID((String)"Window", (String)"org.netbeans.core.windows.actions.ResetWindowsAction");
        if (delegate != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    delegate.actionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HomeVsOtherWindowsSynchronizer.instance().reset();
                                    HomeVsOtherWindowsSynchronizer.instance().setEnabled(true);
                                }
                            });
                        }
                    });
                }
            });
        }
    }
}

