/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import com.paterva.maltego.graph.table.ui.wizard.SampleTableModel;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.IconSize;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JTable;
import org.openide.util.ImageUtilities;

public class LinkSampleTableModel
extends SampleTableModel {
    @Override
    protected Object getHeaderValue(int column) {
        TabularGraphLink link = TabularGraphUtils.getLink((TabularGraph)this.getTabularGraph(), (int)column);
        String columnName = this.getTabularGraph().getColumnNames()[column];
        Object headerValue = null;
        if (link != null) {
            PropertyDescriptor pd = link.getProperty(column);
            Image image = MaltegoLinkSpec.getManualSpec().getIcon(IconSize.MEDIUM.getSize());
            String headerText = this.createHTMLHeader(columnName, pd != null ? pd.getDisplayName() : "");
            headerValue = new SampleHeader(ImageUtilities.image2Icon((Image)image), headerText, link.getIndex());
        } else {
            headerValue = this.createHTMLHeader(columnName, "Unmapped");
        }
        return headerValue;
    }

    @Override
    protected void onColumnSelected(int column) {
        JTable table;
        TabularGraphLink link = TabularGraphUtils.getLink((TabularGraph)this.getTabularGraph(), (int)column);
        if (link != null && (table = this.getTable()) instanceof SampleTableModel.CustomizedSelectionTable) {
            SampleTableModel.CustomizedSelectionTable cst = (SampleTableModel.CustomizedSelectionTable)((Object)table);
            cst.select(link.getColumns());
        }
    }

    @Override
    protected void onColumnToggled(int[] previousSelectedColumns, int column, boolean isSelected) {
        List links = TabularGraphUtils.getLinks((TabularGraph)this.getTabularGraph(), (int[])previousSelectedColumns);
        if (links.size() == 1) {
            TabularGraphLink selectedLink = (TabularGraphLink)links.get(0);
            if (isSelected) {
                TabularGraphLink link = TabularGraphUtils.getLink((TabularGraph)this.getTabularGraph(), (int)column);
                if (link == null) {
                    PropertyDescriptor pd = TabularGraphUtils.getNextUnusedProperty((TabularGraphLink)selectedLink);
                    selectedLink.put(column, pd);
                }
            } else {
                selectedLink.remove(new int[]{column});
            }
            this.updateTableHeaders();
        }
    }

    @Override
    protected void onTabularGraphChanged(PropertyChangeEvent evt) {
        super.onTabularGraphChanged(evt);
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("linkAdded".equals(evt.getPropertyName()) || "linkRemoved".equals(evt.getPropertyName()) || "linkUpdated".equals(evt.getPropertyName()) || "columnNamesChanged".equals(evt.getPropertyName())) {
            this.updateTableHeaders();
        }
    }
}

