/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.ui.wizard.PropertyTableModel;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityPropertyTableModel
extends PropertyTableModel {
    private final int STRICT_COLUMN = this.getColumnCount() - 1;

    @Override
    protected String[] getColumnNames() {
        String[] columnNames = super.getColumnNames();
        columnNames = Arrays.copyOf(columnNames, columnNames.length + 1);
        columnNames[columnNames.length - 1] = "Strict Matching";
        return columnNames;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.STRICT_COLUMN == columnIndex) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return super.isCellEditable(rowIndex, columnIndex) || columnIndex == this.STRICT_COLUMN;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getTabularGraph() == null || this.getMap() == null) {
            return null;
        }
        if (this.STRICT_COLUMN == columnIndex) {
            PropertyToColumnMap map = this.getMap();
            PropertyDescriptor pd = map.getProperty(map.getColumns()[rowIndex]);
            boolean strict = false;
            if (pd != null) {
                String specName = this.getSpecName(this.getMap());
                TabularGraph tabularGraph = this.getTabularGraph();
                Map strictProps = tabularGraph.getTypeStrictProperties();
                Set props = (Set)strictProps.get(specName);
                strict = props == null ? this.isValueProperty(specName, pd) : props.contains(pd.getName());
            }
            return strict;
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    private boolean isValueProperty(String specName, PropertyDescriptor pd) {
        PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty((SpecRegistry)EntityRegistry.getDefault(), (String)specName);
        return valueProperty != null && pd.getName().equals(valueProperty.getName());
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.STRICT_COLUMN == columnIndex) {
            PropertyToColumnMap map = this.getMap();
            String specName = this.getSpecName(map);
            TabularGraph tabularGraph = this.getTabularGraph();
            Map strictProps = tabularGraph.getTypeStrictProperties();
            HashSet<String> props = (HashSet<String>)strictProps.get(specName);
            if (props == null) {
                props = new HashSet<String>();
                strictProps.put(specName, props);
            }
            PropertyDescriptor pd = map.getProperty(map.getColumns()[rowIndex]);
            String propName = pd.getName();
            if (Boolean.TRUE.equals(value)) {
                props.add(propName);
            } else {
                props.remove(propName);
            }
        } else {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }

    @Override
    protected String getSpecName(PropertyToColumnMap map) {
        return ((TabularGraphEntity)map).getEntitySpecName();
    }

    @Override
    protected DisplayDescriptorCollection getTypeProperties(PropertyToColumnMap map) {
        MaltegoEntitySpec spec = TabularGraphUtils.getSpec((TabularGraphEntity)((TabularGraphEntity)map));
        return spec == null ? null : InheritanceHelper.getAggregatedProperties((SpecRegistry)EntityRegistry.getDefault(), (String)spec.getTypeName());
    }

    @Override
    protected boolean isMapped(TabularGraph tabularGraph, String specName, PropertyDescriptor property) {
        for (TabularGraphEntity entity : tabularGraph.getEntities()) {
            Set pds;
            if (!entity.getEntitySpecName().equals(specName) || !(pds = TabularGraphUtils.getProperties((PropertyToColumnMap)entity, (int[])new int[0])).contains(property)) continue;
            return true;
        }
        return false;
    }
}

