# 2025-07-22 Triage Log

Fairly busy week with improvements outweighing regressions. Most of the regressions were considered acceptable given the circumstances (such as landing a long awaited feature). By far the biggest win comes from being a bit smarter about hashing certain information inside of `DefPathHash`. Since hashing happens quite a lot in the compiler's query system, optimizing when hashing happens can have large performance impacts.

Triage done by **@rylev**.
Revision range: [a9fb6103..3f9f20f7](https://perf.rust-lang.org/?start=a9fb6103b05c6ad6eee6bed4c0bb5a2e8e1024c6&end=3f9f20f71dd945fe7d044e274094a53c90788269&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 0.9%]   | 47    |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.1%, 2.7%]   | 69    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-4.1%, -0.2%] | 122   |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.5%, -0.0%] | 143   |
| All ❌✅ (primary)                 | -0.5% | [-4.1%, 0.9%]  | 169   |


3 Regressions, 8 Improvements, 8 Mixed; 8 of them in rollups
35 artifact comparisons made in total

#### Regressions

Miri subtree update [#144019](https://github.com/rust-lang/rust/pull/144019) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5795086bdfe7ed988aa53a110bd0692c33d8755b&end=fd2eb391d032181459773f3498c17b198513e0d0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.5%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- Noise


Implement unstable trait impl [#140399](https://github.com/rust-lang/rust/pull/140399) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd2eb391d032181459773f3498c17b198513e0d0&end=014bd8290f084c714995205a9116e6c035419ae6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 65    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.3%]   | 60    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.3%  | [-0.3%, 0.8%]  | 67    |
- "The perf regressions were deemed to be acceptable for the time being, to avoid delaying this feature."


tests: Require `run-fail` ui tests to have an exit code (`SIGABRT` not ok) [#143002](https://github.com/rust-lang/rust/pull/143002) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ee3a0783df39cb11c5706e38805eb9258b4fad79&end=6707bf0f59485cf054ac1095725df43220e4be20&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.4%, 0.8%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 1     |
- Noise


#### Improvements

Rollup of 12 pull requests [#144028](https://github.com/rust-lang/rust/pull/144028) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c6de215099bbe33668de762f9591187f6c25eef&end=5795086bdfe7ed988aa53a110bd0692c33d8755b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 13    |
| All ❌✅ (primary)                 | -     | -              | 0     |


Rollup of 15 pull requests [#144044](https://github.com/rust-lang/rust/pull/144044) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=014bd8290f084c714995205a9116e6c035419ae6&end=f8f6997469237299c1d60814c7b9828602a1f8e4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.6%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.5%, -0.2%] | 27    |
| All ❌✅ (primary)                 | -0.7% | [-1.6%, -0.2%] | 21    |


Only inherit local hash for paths [#142903](https://github.com/rust-lang/rust/pull/142903) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f8f6997469237299c1d60814c7b9828602a1f8e4&end=8c12d76304fcceaeaad0d67209e5727e94f5f2b8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.0%, -0.2%] | 140   |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.2%, -0.1%] | 105   |
| All ❌✅ (primary)                 | -0.4% | [-1.0%, -0.2%] | 140   |


Rollup of 11 pull requests [#144130](https://github.com/rust-lang/rust/pull/144130) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6caa224a242d4c7b06c317969c51862815a4454b&end=82310651b93a594a3fd69015e1562186a080d94c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 6     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 3     |


Rollup of 5 pull requests [#144181](https://github.com/rust-lang/rust/pull/144181) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0d9592026226f5a667a0da60c13b955e0b486a07&end=ee3a0783df39cb11c5706e38805eb9258b4fad79&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.9%, -0.2%] | 7     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 3     |


Weekly `cargo update` [#143861](https://github.com/rust-lang/rust/pull/143861) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0864097cd31ee30f5081ba588a5c9820c2c6fc71&end=9982d6462bedf1e793f7b2dbd655a4e57cdf67d4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 3     |


Consider param-env for sizedness fast path [#143309](https://github.com/rust-lang/rust/pull/143309) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9982d6462bedf1e793f7b2dbd655a4e57cdf67d4&end=460259d14de0274b97b8801e08cb2fe5f16fdac5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-2.9%, -0.3%] | 16    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-2.9%, -0.1%] | 19    |
| All ❌✅ (primary)                 | -1.1% | [-2.9%, 0.3%]  | 18    |


Rollup of 8 pull requests [#144238](https://github.com/rust-lang/rust/pull/144238) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e05ab47e6c418fb2b9faa2eae9a7e70c65c98eaa&end=67819923ac8ea353aaa775303f4c3aacbf41d010&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 6     |


#### Mixed

`std::vec`: Add UB check for `set_len`, `from_raw_parts_in`, and etc. [#143877](https://github.com/rust-lang/rust/pull/143877) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e27f16a499074ba9a87f7f7641d9f64c572863bc&end=3014e79f9c8d5510ea7b3a3b70d171d0948b1e96&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.3%, 0.9%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.6%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.1%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-2.1%, 0.9%]  | 7     |
- Perf is acceptable for being able to catch UB


resolve: Merge `NameBindingKind::Module` into `NameBindingKind::Res` [#143458](https://github.com/rust-lang/rust/pull/143458) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f21fbac535ab2c3bc50db20547f4d48477357103&end=1c6de215099bbe33668de762f9591187f6c25eef&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.7%, 0.8%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-2.1%, -0.1%] | 30    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-1.4%, -0.0%] | 65    |
| All ❌✅ (primary)                 | -0.5% | [-2.1%, 0.2%]  | 31    |
- Improvements vastly outweigh regressions (which might just be noise)


Rollup of 11 pull requests [#144058](https://github.com/rust-lang/rust/pull/144058) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c12d76304fcceaeaad0d67209e5727e94f5f2b8&end=bf5e6cc7a7a7eb03e3ed9b875d76530eddd47d5f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 15    |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |
- The only regression seems like it might just be returning to a previous baseline so it's not worth investigating.


`-Zhigher-ranked-assumptions`: Consider WF of coroutine witness when proving outlives assumptions [#143545](https://github.com/rust-lang/rust/pull/143545) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e4662966273ed58b51f9ff8d682accc202aa1210&end=1aa5b2246560ce85b42fa8b33e5927c5de3fa389&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 0.5%]   | 29    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 0.6%]   | 50    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.1%, 0.5%]   | 29    |
- Asked the author and reviewer for thoughts on performance since the regressions were certainly not unexpected, but the PR was merged anyway.


Rollup of 11 pull requests [#144109](https://github.com/rust-lang/rust/pull/144109) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1aa5b2246560ce85b42fa8b33e5927c5de3fa389&end=6c0a912e5a45904cf537f34876b16ae71d899f86&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 8     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-1.5%, -1.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-1.5%, 0.4%]  | 4     |
-  The relative size of the regressions are fairly small, I don't think it's worth the investigation.


Split-up stability_index query [#143845](https://github.com/rust-lang/rust/pull/143845) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=82310651b93a594a3fd69015e1562186a080d94c&end=8f08b3a32478b8d0507732800ecb548a76e0fd0c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 29    |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.1%, 3.3%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 23    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.2%] | 14    |
| All ❌✅ (primary)                 | 0.0%  | [-0.6%, 0.4%]  | 52    |
- As [stated here](https://github.com/rust-lang/rust/pull/143845#pullrequestreview-3024720852), the perf regressions were considered acceptable.


Rollup of 9 pull requests [#144145](https://github.com/rust-lang/rust/pull/144145) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ebd8557637b33cc09b6ee8273f3154d5d3af6a15&end=1079c5edb2bd837e5c4cf8c7db2892db359a3862&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.5%, 2.8%]   | 9     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.3%, -0.0%] | 2     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Simplify discriminant codegen for niche-encoded variants which don't wrap across an integer boundary [#143784](https://github.com/rust-lang/rust/pull/143784) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1079c5edb2bd837e5c4cf8c7db2892db359a3862&end=83825dd277503edf5d7eda6be8b5fb9896f343f5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.4%, 0.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 1.6%  | [1.6%, 1.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.3%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.2%] | 20    |
| All ❌✅ (primary)                 | -0.2% | [-1.3%, 0.8%]  | 20    |
- [Perf was considered acceptable](https://github.com/rust-lang/rust/pull/143784#issuecomment-3092568339).

