require File.expand_path(File.dirname(__FILE__) + '/spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/../lib/pedump')
require 'yaml'

describe "imports" do
  it "should consider sample function names as good" do
    samples = <<-EOF
      ??0CCalcExpressao@@QAE@PAVCfcDatabase@@PAVCThreadMgr@@PAVCErrorMgr@@_N@Z
      ??0CCicleCheck@@QAE@PAVCfcDatabase@@VCString@@1@Z
      ??0CDate@@QAE@ABV0@@Z
      ??0CDate@@QAE@N@Z
      ??0CDate@@QAE@XZ
      ??0CDigitalOptionCalc@@QAE@NDD@Z
      ??0CDoubleBarrierDigitalOption@@QAE@NDD@Z
      ??0CErrorDescriptor@@QAE@ABV0@@Z
      ??0CErrorDescriptor@@QAE@HVCString@@000@Z
      ??0CInternationalGUI@@QAE@PAVCfcDatabase@@@Z
      ??0CInterpolador@@QAE@XZ
      ??0CMAPSFixedAlloc@@QAE@II@Z
      ??0CMatriz@@QAE@XZ
      ??0COptionsAmCalc@@QAE@NDD@Z
      ??0COptionsBarrierCalc@@QAE@NDDDDNN@Z
      ??0COptionsEuroCalc@@QAE@NDD@Z
      ??0CRedomaServer@@QAE@XZ
      ??0CSettings@@QAE@XZ
      ??0CSingleBarrierDigitalOption@@QAE@NDD@Z
      ??0OraDisjunct@@QAE@XZ
      ??0clBenchPair@@QAE@AAV0@@Z
      ??0clBenchPair@@QAE@VCString@@N@Z
      ??0clBinomialTreeCalc@@QAE@NDD@Z
      ??0clBookBenchmark@@QAE@XZ
      ??0clColRetSerie@@QAE@XZ
      ??0clColSerie@@QAE@XZ
      ??0clDBCache@@QAE@PAVCfcDatabase@@@Z
      ??0clFluxoCaixa@@QAE@AAV0@@Z
      ??0clGetFolderPath@@QAE@XZ
      ??0clHiperVolatServer@@QAE@PAVclDBCache@@PAVCfcDatabase@@PAVCRedomaServer@@PAVCErrorMgr@@@Z
      ??0clMapsStatusBar@@QAE@PAVCStatusBar@@@Z
      ??0clMapsTracer@@QAE@VCString@@@Z
      ??0clMapsTracer@@QAE@XZ
      ??0clMatrix@@QAE@AAV0@@Z
      ??0clMatrix@@QAE@HHN@Z
      ??0clPUTaxa@@QAE@XZ
      ??0clProdDesc@@QAE@XZ
      ??0clProdExt@@QAE@XZ
      ??0clRetSerie@@QAE@VCString@@@Z
      ??0clRetSerie@@QAE@XZ
      ??0clSerie@@QAE@XZ
      ??0clSpotSerie@@QAE@VCString@@@Z
      ??0clStringBuilder@@QAE@ABV0@H@Z
      ??0clStringBuilder@@QAE@H@Z
      ??0clSurfaceBase@@QAE@H@Z
      ??0clTaxaMachine@@QAE@XZ
      ??0clValor@@QAE@AAV0@@Z
      ??0clValor@@QAE@NN@Z
      ??0clValor@@QAE@XZ
      ??0clVector@@QAE@HN@Z
      ??0clVertice@@QAE@ABV0@@Z
      ??0clVertice@@QAE@VCString@@NNNN@Z
      ??0clVertice@@QAE@XZ
      ??0fcAcessoBD@@QAE@PAVCfcDatabase@@VCString@@111@Z
      ??0fcAcessoEscritaBD@@QAE@PAVCfcDatabase@@VCString@@111@Z
      ??0fcAcessoExcep@@QAE@VCString@@@Z
      ??1CBufferFile@@UAE@XZ
      ??1CCalcExpressao@@UAE@XZ
      ??1CCicleCheck@@UAE@XZ
      ??1CDate@@UAE@XZ
      ??1CErrorDescriptor@@UAE@XZ
      ??1CInternationalGUI@@UAE@XZ
      ??1CInterpolador@@UAE@XZ
      ??1CMAPSFixedAlloc@@QAE@XZ
      ??1CMAPSLicMgr@@UAE@XZ
      ??1CMatriz@@UAE@XZ
      ??1CNetMatriz@@UAE@XZ
      ??1CSettings@@UAE@XZ
      ??1CStringStore@@UAE@XZ
      ??1CStrongStringStore@@UAE@XZ
      ??1CfcCompactDatabase@@UAE@XZ
      ??1OraDisjunct@@QAE@XZ
      ??1SimpleException@@UAE@XZ
      ??1clBookBenchmark@@UAE@XZ
      ??1clChronometer@@UAE@XZ
      ??1clColRetSerie@@UAE@XZ
      ??1clColSerie@@UAE@XZ
      ??1clGetFolderPath@@UAE@XZ
      ??1clMapsStatusBar@@UAE@XZ
      ??1clMapsTracer@@UAE@XZ
      ??1clMatrix@@UAE@XZ
      ??1clMatrixException@@UAE@XZ
      ??1clPUTaxa@@UAE@XZ
      ??1clProdDesc@@UAE@XZ
      ??1clProdExt@@UAE@XZ
      ??1clStringBuilder@@UAE@XZ
      ??1clSurface@@UAE@XZ
      ??1clTaxaMachine@@UAE@XZ
      ??1clValor@@UAE@XZ
      ??1clVertice@@UAE@XZ
      ??1clVolatModels@@UAE@XZ
      ??1fcAcessoApagaBD@@UAE@XZ
      ??1fcAcessoBD@@UAE@XZ
      ??1fcAcessoBufferBD@@UAE@XZ
      ??1fcAcessoEscritaBD@@UAE@XZ
      ??1fcAcessoExcep@@UAE@XZ
      ??1type_info@@UAE@XZ
      ??4CDate@@QAEAAV0@ABV0@@Z
      ??4CDate@@QAEAAV0@N@Z
      ??4CSettings@@QAEAAV0@AAV0@@Z
      ??4clValor@@QAEAAV0@AAV0@@Z
      ??BCDate@@QAENXZ
      ??BclStringBuilder@@QBE?AVCString@@XZ
      ??NCDate@@QAE_NABV0@@Z
      ??OCDate@@QAE_NABV0@@Z
      ??YclStringBuilder@@QAEAAV0@AAVCString@@@Z
      ??YclStringBuilder@@QAEAAV0@PBD@Z
      ?Add@clBookBenchmark@@QAEXVCString@@N@Z
      ?AddError@CErrorMgr@@QAAXHVCString@@0PBDZZ
      ?AddError@CErrorMgr@@QAEXVCErrorDescriptor@@@Z
      ?AddNew@fcAcessoEscritaBD@@QAE_N_N@Z
      ?AddNode@CInterpolador@@UAE_NNN@Z
      ?AddRetQuickPointer@clRetSerie@@QAEHPAVclValor@@@Z
      ?AddRetSerie@clColRetSerie@@QAEHAAVclRetSerie@@@Z
      ?AddSerie@clColSerie@@QAE_NPAVclSerie@@@Z
      ?AddSpot@clSpotSerie@@QAEHAAVCObList@@@Z
      ?AddSpot@clSpotSerie@@QAEHAAVclValor@@@Z
      ?AddSpotPointer@clSpotSerie@@QAEHPAVclValor@@@Z
      ?AddValor@clSerie@@QAEXAAVclValor@@@Z
      ?AddValor@clSerie@@QAEXNN@Z
      ?AddValor@clSerie@@QAEXPAVclValor@@@Z
      ?AdjustColTotals@CNetMatriz@@UAEXN@Z
      ?AdjustToNextValidDate@CDate@@SAXAAH00@Z
      ?AdjustToPrevValidDate@CDate@@SAXAAH00@Z
      ?AdjustTotals@CNetMatriz@@UAEXNHN@Z
      ?AdvanceNMonths@CDate@@QAE_NH@Z
      ?AdvanceToNextMonth@CDate@@QAE_NXZ
      ?Alloc@CMAPSFixedAlloc@@QAEPAXXZ
      ?BackToPrevMonth@CDate@@QAE_NXZ
      ?CaculateEwmaLambdaSampleSize@clVolatModels@@SAHN@Z
      ?CalcDP@clVolatModels@@SA_NPANHAAN@Z
      ?CalcEwmaNi@clVolatModels@@SA_NPANHNAAN@Z
      ?CalcGarch_1_1@clVolatModels@@SA_NPANHHAAN@Z
      ?CalcSemiVariance@clVolatModels@@SA_NPANHHAAN@Z
      ?CalcTxEfetiva@clTaxaMachine@@QAE_NNNNVCString@@DAAN@Z
      ?CalcTxEfetivaMes@clTaxaMachine@@QAE_NHNVCString@@DAAN@Z
      ?CalcVF@clTaxaMachine@@EAEHNNNNVCString@@DAAN@Z
      ?CalcVolatEwmaLambda@clVolatModels@@SA_NPANHNAAN@Z
      ?CalculaExpressao@CCalcExpressao@@QAENXZ
      ?ChangeCellValue@CMatriz@@UAEXHHVCString@@N@Z
      ?ChangeScaleDbl@CMatriz@@QAEXN@Z
      ?Check@CCicleCheck@@QAE_NXZ
      ?ClearAllValues@CMatriz@@QAEXXZ
      ?Close@fcAcessoBD@@QAEXXZ
      ?Close@fcAcessoEscritaBD@@QAEXXZ
      ?CodeToMessage@SimpleException@@MAE?AVCString@@H@Z
      ?CodeToMessage@clMatrixException@@MAE?AVCString@@H@Z
      ?Congele@clRetSerie@@QAEHXZ
      ?Create@clSurface@@SAPAVclSurfaceBase@@PAVCfcDatabase@@PAVclDBCache@@@Z
      ?Decrypt@CStrongStringStore@@UAE_NVCString@@AAV2@@Z
      ?Delete@fcAcessoEscritaBD@@QAE_NXZ
      ?Descongele@clRetSerie@@QAEHXZ
      ?EmptyList@clSerie@@QAEXXZ
      ?Encrypt@CStrongStringStore@@UAE_NVCString@@AAV2@@Z
      ?FillList@clBookBenchmark@@QAEXAAVCObList@@@Z
      ?Free@CMAPSFixedAlloc@@QAEXPAX@Z
      ?GenerateKey@CStringStore@@MAEIH@Z
      ?GetBasicRedomaPointer@CRedomaServer@@QAEPAVclRedoma@@VCString@@@Z
      ?GetBasicRedomaPointerByCurrencyCode@CRedomaServer@@QAEPAVclRedoma@@VCString@@@Z
      ?GetBasicRedomaPointerByCurrencyName@CRedomaServer@@QAEPAVclRedoma@@VCString@@@Z
      ?GetBasicRedomaPointerForInstalation@CRedomaServer@@QAEPAVclRedoma@@XZ
      ?GetCellValue@CMatriz@@UAE?AVCString@@HH@Z
      ?GetCen1Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen1Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen1Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen2Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen2Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen2Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen3Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen3Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen3Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen4Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen4Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen4Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen5Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen5Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen6Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCen6Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetCenDesc@clDBCache@@QAEPAVCStringList@@AAVCString@@0@Z
      ?GetCenDescGui@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetCenDescInter@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetCenDescMostra@clDBCache@@QAEHAAVCString@@@Z
      ?GetCenDescPU@clDBCache@@QAEPAVCObList@@AAVCString@@H@Z
      ?GetCenDescPais@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetCenDescTipoAlpha@clDBCache@@QAEHAAVCString@@@Z
      ?GetCenDescTipoCalculo@clDBCache@@QAEHAAVCString@@@Z
      ?GetCenDescTipoStress@clDBCache@@QAEHAAVCString@@@Z
      ?GetCenDescVertInfo@clDBCache@@QAEPAVCObList@@AAVCString@@@Z
      ?GetCenDescVolInter@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetCenIsSint@clDBCache@@QAE_NAAVCString@@@Z
      ?GetCodigoMoedaFromMoeda@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetColLabel@CMatriz@@QAE?AVCString@@H@Z
      ?GetConfidenceFactor@clRetSerie@@QAE_NAAN@Z
      ?GetCorrel@clColRetSerie@@QAEHVCString@@0AANHN@Z
      ?GetCovar@clColRetSerie@@QAEHVCString@@0AANH_NNN@Z
      ?GetDatabaseType@CfcDatabase@@QAEHXZ
      ?GetDateISO8601@CDate@@QAE?AVCString@@XZ
      ?GetDateJulian@CDate@@QAENXZ
      ?GetDateJulian@CDate@@SANHHH@Z
      ?GetDateString@CDate@@QAE?AVCString@@XZ
      ?GetDates@CDate@@QAE_NAAH00@Z
      ?GetDates@CDate@@SAXNAAH00@Z
      ?GetDirectHistSerie@clHiperVolatCube@@QAE_NVCString@@NNAAHAAPAN2@Z
      ?GetEarlyDate@clRetSerie@@QAENXZ
      ?GetEmptyHiperVolatCube@clHiperVolatServer@@QAEPAVclHiperVolatCube@@VCString@@@Z
      ?GetErrorCode@SimpleException@@UAEHXZ
      ?GetErrorMessage@SimpleException@@UAE?AVCString@@XZ
      ?GetFat1Cen1Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen1Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen2Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen3Ind1@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen3Ind2@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen3Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen4Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen5Ind3@clDBCache@@QAE?AVCString@@AAV2@0@Z
      ?GetFat1Cen@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetFatCloseValue@clDBCache@@QAENAAVCString@@H@Z
      ?GetFatParamRisco@clDBCache@@QAEPAVclFatParamRisco@@AAVCString@@0N@Z
      ?GetFatStress@clDBCache@@QAEPAVclMetodoArgumentoInfo@@AAVCString@@0@Z
      ?GetFatVertice@clDBCache@@QAEPAVclCenDescVertInfo@@AAVCString@@@Z
      ?GetFatorAllSerieHist@clDBCache@@QAEPAVCObList@@AAVCString@@@Z
      ?GetFatorCenDesc@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetFatorSerieHist@clDBCache@@QAEPAVCObList@@AAVCString@@00@Z
      ?GetFieldValue@fcAcessoBD@@QAE_NAAHH@Z
      ?GetFieldValue@fcAcessoBD@@QAE_NAAJH@Z
      ?GetFieldValue@fcAcessoBD@@QAE_NAANH@Z
      ?GetFieldValue@fcAcessoBD@@QAE_NAAVCDate@@H@Z
      ?GetFieldValue@fcAcessoBD@@QAE_NAAVCString@@H@Z
      ?GetFlagVolat@clRetSerie@@QAEHXZ
      ?GetFluxoCaixa@clDBCache@@QAEPAVCObList@@AAVCString@@0@Z
      ?GetFluxoCaixaAdv@clDBCache@@QAEPAVCObList@@AAVCString@@0@Z
      ?GetFluxoCaixaAdvLibor@clDBCache@@QAEPAVCObList@@AAVCString@@0@Z
      ?GetGrupoFat@clDBCache@@QAEPAVCStringList@@AAVCString@@H@Z
      ?GetGrupoProd@clDBCache@@QAEPAVCStringList@@AAVCString@@@Z
      ?GetGuiDate@CInternationalGUI@@QAE?AVCString@@AAVCDate@@@Z
      ?GetGuiDate@CInternationalGUI@@QAE?AVCString@@N@Z
      ?GetGuiQuant@CInternationalGUI@@QAE?AVCString@@N@Z
      ?GetGuiReal@CInternationalGUI@@QAE?AVCString@@N@Z
      ?GetGuiReal@CInternationalGUI@@QAE?AVCString@@NH@Z
      ?GetHiperVolatCube@clHiperVolatServer@@QAEPAVclHiperVolatCube@@VCString@@NN@Z
      ?GetHipercuboForModeloABCallPut@clDBCache@@QAE?AVCString@@AAV2@00_N@Z
      ?GetHipercuboInfo@clDBCache@@QAEPAVclHipercuboInfo@@AAVCString@@@Z
      ?GetHistSerie@clHiperVolatCube@@QAE_NNNAAHAAPAN1@Z
      ?GetIndStress@clDBCache@@QAEPAVclMetodoArgumentoInfo@@AAVCString@@0@Z
      ?GetIndexadorInfo@clDBCache@@QAEPAVCObList@@AAVCString@@0@Z
      ?GetInternalList@clRetSerie@@QAEAAVCObList@@XZ
      ?GetInternalList@clSerie@@QAEAAVCObList@@XZ
      ?GetInternalList@clSpotSerie@@QAEAAVCObList@@XZ
      ?GetKey@CStringStore@@MAE?AVCString@@V2@@Z
      ?GetLateDate@clRetSerie@@QAENXZ
      ?GetMapsBinDir@clGetFolderPath@@SA?AVCString@@XZ
      ?GetMessageA@CStringStore@@MAE?AVCString@@V2@@Z
      ?GetMoedaForHipercubo@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetNFactors@clBookBenchmark@@QAEHXZ
      ?GetNRet@clRetSerie@@QAEHXZ
      ?GetNSpot@clSpotSerie@@QAEHXZ
      ?GetOptionExpByProd@clDBCache@@QAE_NAAVCString@@0AAH111@Z
      ?GetOptionGlbExp@clDBCache@@QAE_NAAH000@Z
      ?GetPU@clPUTaxa@@QAENN@Z
      ?GetPU@clTaxaMachine@@QAE_NVCString@@DNNNAAN@Z
      ?GetPaisFromMoeda@clDBCache@@QAE?AVCString@@AAV2@@Z
      ?GetPointer@CRedomaServer@@QAEPAVCRedoma@@VCString@@@Z
      ?GetProdBC2972@clDBCache@@QAEHAAVCString@@0@Z
      ?GetProdCorrecaoStepVar@clDBCache@@QAEHAAVCString@@0H@Z
      ?GetProdDesc@clDBCache@@QAEPAVclProdDesc@@AAVCString@@0@Z
      ?GetProdExt@clDBCache@@QAEPAVclProdExt@@AAVCString@@0@Z
      ?GetProdFloatMoedaModoMistoSpot@clDBCache@@QAEHAAVCString@@0H@Z
      ?GetProdOpcaoAjusteTxDelay@clDBCache@@QAEHAAVCString@@0H@Z
      ?GetProdPadraoCashFlowD1@clDBCache@@QAE_NAAVCString@@@Z
      ?GetProdPadraoIgnFlowD1@clDBCache@@QAE_NAAVCString@@@Z
      ?GetProdTemPL@clDBCache@@QAEHAAVCString@@0H@Z
      ?GetProdTipoRating@clDBCache@@QAE_NAAVCString@@0AAH0@Z
      ?GetRawPUs@CInterpolador@@UAEPANXZ
      ?GetRawSize@CInterpolador@@UAEHXZ
      ?GetRealValue@CMatriz@@UAENHH@Z
      ?GetRet@clRetSerie@@QAE?AVclValor@@H@Z
      ?GetRetQuick@clRetSerie@@QAEHHAAVclValor@@@Z
      ?GetRetSerie@clSpotSerie@@QAEHHAAVclRetSerie@@_N@Z
      ?GetRiscoCambialSpot@clDBCache@@QAE_NAAVCString@@0AA_N@Z
      ?GetRuntimeClass@CMatriz@@UBEPAUCRuntimeClass@@XZ
      ?GetSerie@clSpotSerie@@QAEPAVclSerie@@XZ
      ?GetSerieConvencaoPeriodo@clDBCache@@QAE_NAAVCString@@00@Z
      ?GetSerieInfo@clDBCache@@QAEPAVclSerieInfo@@AAVCString@@@Z
      ?GetSimId@CfcDatabase@@QAEHXZ
      ?GetSize@CStringStore@@MAEDVCString@@@Z
      ?GetSize@clSerie@@QAEHXZ
      ?GetSpot@clSpotSerie@@QAE?AVclValor@@H@Z
      ?GetStress@clCenDescRules@@QAE_NNHAANVCString@@1@Z
      ?GetStressFTE@clCenDescRules@@QAE_NNHAANVCString@@1@Z
      ?GetString@CStringStore@@UAE?AVCString@@V2@@Z
      ?GetString@CStrongStringStore@@UAE?AVCString@@V2@@Z
      ?GetSurface@clHiperVolatCube@@QAEPAVclSurfaceBase@@H@Z
      ?GetSysDataParametro@clDBCache@@QAE?AVCString@@V2@0@Z
      ?GetTipoProdBC2972@clDBCache@@QAEHAAVCString@@@Z
      ?GetTipoProdRetiraD1@clDBCache@@QAEHAAVCString@@@Z
      ?GetValue@clPUTaxa@@QAENN@Z
      ?GetVolat@clRetSerie@@QAE_NAAN@Z
      ?Initialize@CInterpolador@@UAE_N_N@Z
      ?Initialize@CRedomaServer@@QAEXPAVCfcDatabase@@PAVCErrorMgr@@@Z
      ?Initialize@clMapsTracer@@QAE_NVCString@@@Z
      ?InsertProduct@CMatriz@@UAE_NVCString@@PAVCStringList@@1NN@Z
      ?InsertProduct@CMatriz@@UAE_NVCString@@PAVCStringList@@PAV?$CList@NN@@NN@Z
      ?IsBOF@fcAcessoBD@@QAE_NXZ
      ?IsBOF@fcAcessoEscritaBD@@QAE_NXZ
      ?IsEOF@fcAcessoBD@@QAE_NXZ
      ?IsEOF@fcAcessoEscritaBD@@QAE_NXZ
      ?IsInBissextYear@CDate@@QAE_NXZ
      ?IsTraceOn@clMapsTracer@@UAE_NXZ
      ?IsWeekend@CDate@@QAEHXZ
      ?KeyToString@CStringStore@@MAE?AVCString@@I@Z
      ?LoadSettings@CSettings@@QAE_NXZ
      ?Log@CML@@SAXPBDZZ
      ?Log@CML@@SAXVCString@@@Z
      ?MoveNext@fcAcessoBD@@QAEXXZ
      ?MoveNext@fcAcessoEscritaBD@@QAEXXZ
      ?Normalize@clBookBenchmark@@QAEXN@Z
      ?PutString@CStringStore@@UAE?AVCString@@V2@@Z
      ?PutString@CStrongStringStore@@UAE?AVCString@@V2@@Z
      ?RemoveAll@clBookBenchmark@@QAEXXZ
      ?ReportError@SimpleException@@UAEXXZ
      ?SetAssetOrNothing@CDigitalOptionCalc@@QAEX_N@Z
      ?SetCStatusBar@clMapsStatusBar@@QAEXPAVCStatusBar@@@Z
      ?SetCellValue@CMatriz@@MAEXHHVCString@@@Z
      ?SetColTotals@CMatriz@@UAEXAAVCStringList@@0N@Z
      ?SetConfidenceLevel@clRetSerie@@QAEHN@Z
      ?SetConfidenceMethod@clRetSerie@@QAEHVCString@@H@Z
      ?SetCorrelMethod@clColRetSerie@@QAEHVCString@@_NH@Z
      ?SetDate@CDate@@QAE_NHHH@Z
      ?SetDate@CDate@@QAE_NN@Z
      ?SetDate@CDate@@QAE_NVCString@@@Z
      ?SetDefinitions@clPUTaxa@@QAE_N_NNVCString@@1@Z
      ?SetErrorMgr@CMatriz@@UAEXPAVCErrorMgr@@@Z
      ?SetFieldValue@fcAcessoEscritaBD@@QAEXFVCString@@@Z
      ?SetFieldValue@fcAcessoEscritaBD@@QAEXHVCString@@@Z
      ?SetFieldValue@fcAcessoEscritaBD@@QAEXNVCString@@@Z
      ?SetFieldValue@fcAcessoEscritaBD@@QAEXVCString@@0@Z
      ?SetInterpolationMethod@CInterpolador@@UAE_NVCString@@@Z
      ?SetMethod@clBookBenchmark@@QAEXH@Z
      ?SetName@clBookBenchmark@@QAEXVCString@@@Z
      ?SetName@clRetSerie@@QAEHVCString@@@Z
      ?SetNew@clMapsStatusBar@@QAEXVCString@@H@Z
      ?SetParameters@CSettings@@QAEXPAVCfcDatabase@@PAVCErrorMgr@@@Z
      ?SetParentPointers@CNetMatriz@@QAEXPAVCMatriz@@0@Z
      ?SetPositionDate@CInterpolador@@UAE_NN@Z
      ?SetPrev@clMapsStatusBar@@QAEXH@Z
      ?SetRealValue@CMatriz@@MAE_NHHN@Z
      ?SetRedomaPointer@CInterpolador@@UAE_NPAVclRedoma@@@Z
      ?SetRedomaPointer@clTaxaMachine@@QAE_NPAVclRedoma@@@Z
      ?SetRowValue@CNetMatriz@@UAEXPAVCStringList@@H0@Z
      ?SetRowValue@CNetMatriz@@UAEXPAVCStringList@@HPAV?$CList@NN@@@Z
      ?SetSampleSizeMethod@clRetSerie@@QAEHVCString@@HHHH@Z
      ?SetSpaceType@CInterpolador@@UAE_NVCString@@0@Z
      ?SetType@clSpotSerie@@QAEHHVCString@@0NN@Z
      ?SetVolatMethod@clRetSerie@@QAEHVCString@@HHN_NH@Z
      ?SetVolatility@clRetSerie@@QAEXN@Z
      ?ShrinkVectors@CInterpolador@@QAEXXZ
      ?SortColumns@CMatriz@@QAEXAAVCStringList@@@Z
      ?StartTrace@clMapsTracer@@UAE_NVCString@@@Z
      ?StringToKey@CStringStore@@MAEIVCString@@@Z
      ?Subst@clMapsStatusBar@@QAEXVCString@@H@Z
      ?Synchronize@clColSerie@@QAEHXZ
      ?TurnAllAbsolute@CMatriz@@UAEXXZ
      ?VerificaFormula@CCalcExpressao@@QAE_NVCString@@@Z
      ?WriteTraceLine@clMapsTracer@@UAE_NVCString@@00@Z
      ?WriteTraceLine@clMapsTracer@@UAE_NVCString@@@Z
      ?WriteTraceLine@clMapsTracer@@UAE_NVCString@@H0@Z
      ?WriteTraceLine@clMapsTracer@@UAE_NVCString@@N0@Z
      ?WriteTraceLineFormat@clMapsTracer@@UAA_NPBDZZ
      ?getLambda@clRetSerie@@QAENXZ
      ?getTokens@OraDisjunct@@QAEXAAVCStringList@@@Z
      ?splitTokens@OraDisjunct@@QAEXIAAVCStringList@@@Z
      ?terminate@@YAXXZ
      EnableWindow
      RegCloseKey
      RegOpenKeyExA
      RegQueryValueExA
      ResumeThread
      RpcStringFreeA
      SendMessageA
      SetEvent
      UpdateWindow
      UuidCreate
      UuidToStringA
      _CIpow
      _CxxThrowException
      __CxxFrameHandler
      __dllonexit
      _adjust_fdiv
      _except_handler3
      _finite
      _ftol
      _initterm
      _isnan
      _mbscmp
      _mbsicmp
      _mbsicoll
      _onexit
      _purecall
      atof
      atoi
      ceil
      floor
      free
      malloc
      tolower
    EOF
    samples.strip.split("\n").each do |sample|
      sample.strip.should =~ PEdump::GOOD_FUNCTION_NAME_RE
    end
  end
end
