% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    copyright = "2004"
    subtitle = "String orchestra techniques"
    title = "Notation demonstration"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*37 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 120  \skip 1*16 
    \tempo 4 = 60  \skip 1*2 
    \tempo 4 = 120  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 1, strings" << 
            \set Staff.instrumentName = \markup { \center-column { "strings " } }
            \set Staff.midiInstrument = ""
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 0.0" {
                % Segment: Strings
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 4/4
                
                \clef "treble"
                \key d \minor
                d' 4 ^\markup { \large "BOW MOVEMENTS" } a' f' a'  |
                g' 4 a' d' 2  |
                d' 4 -\downbow a' -\upbow f' -\downbow a' -\upbow  |
                g' 4 -\downbow a' -\upbow d' 2 -\downbow  |
%% 5
                d' 4 _\markup { \bold \italic "(arco)" } a' f' a'  |
                g' 4 a' 8 r d'' r a' 4 -\downbow  |
                d'' 8 -\upbow [ c'' -\downbow bes' -\upbow a' -\downbow ] g' _\markup { \bold \italic "simile" } [ bes' a' g' ]  |
                f' 8 [ e' f' e' ] d' 4 r  |
                < b d' a' > 4 -\downbow < b a' d' > -\downbow < bes a' e' > -\downbow < bes g' f' > -\downbow  |
%% 10
                < b e' g' > 4 -\downbow < a a' c' > -\downbow < aes c'' g' > -\downbow < aes f' a' > -\downbow  |
                < g c' g' > 4 -\downbow < a e' c' > -\downbow < d a f' > 2 -\downbow  |
                a' 1 ^\markup { \large "... AND LEGATO" } _\markup { \bold \italic "(continuato)" } -\downbow _~  |
                a' 1 _~  |
                a' 1 -\upbow _~  |
%% 15
                a' 1  |
                d' 16 -\downbow _( [ e' f' g' ) ] f' _( [ e' f' e' ) ] d' _( [ e' f' e' ] d' [ c' d' e' ) ]  |
                d' 16 ^\markup { \bold "Andante" } _( [ e' f' g' ] f' [ e' f' e' ] d' [ e' f' e' ] d' [ c' d' e' ]  |
                d' 16 [ e' f' g' ] f' [ e' f' e' ] d' [ e' f' e' ] d' [ c' d' e' ) ]  |
                d' 16 ^\markup { \bold "Tempo I" } _( [ e' f' g' ] f' [ e' ) f' _( e' ) ] d' _( [ e' f' e' ] d' ) [ c' _( d' ) ] r  |
%% 20
                < a' b d' > 4 _\markup { \bold \italic "pizz" } < a' d' b > < a' e' bes > < g' f' bes >  |
                < g' e' b > 4 < a' c' a > < c'' aes g' > < a' f' aes >  |
                < g' c' g > 4 < e' c' a > < a f' d > 2 _\markup { \bold \italic "arco" }  |
                f' 16 ^\markup { \large "Détaché" } _\markup { \bold \italic "détaché" } [ f' g' g' ] a' [ a' g' g' ] f' 8 :8[ g' :8] a' :8[ g' :8]  |
                d'' 4 -\accent c'' 8 -\tenuto [ bes' -\tenuto ] a' -\tenuto [ g' -\tenuto f' -\staccato-\tenuto a' -\staccato-\tenuto ]  |
%% 25
                < b d'' g' e' > 4 ^\markup { \large "legato (again)" } _\markup { \bold \italic "portato" } -\tenuto _( < e' d'' b g' > -\tenuto < b e' d'' g' > -\tenuto < d'' b e' g' > -\tenuto )  |
                < e' f'' a' a > 4 < d' bes g'' a' > < f' d d'' a' > 2  |
                < g' e' b d'' > 4 -\staccato-\tenuto _( < f d'' a' f' > -\staccato-\tenuto < e' a' c'' a > -\staccato-\tenuto < e'' c' e' a' > -\staccato-\tenuto )  |
                < e'' a a' e' > 4 < c'' d' a' f > < d f' a' d'' > 2  |
                c'' 8 -\accent [ a' -\staccatissimo g' -\staccatissimo a' -\staccatissimo ] c'' -\staccatissimo [ f' -\staccatissimo g' -\staccatissimo d' -\staccatissimo ]  |
%% 30
                c'' 8 -\accent [ a' -\staccatissimo g' -\staccatissimo a' -\staccatissimo ] c'' -\staccatissimo [ f' -\staccatissimo e' -\staccatissimo d' -\staccatissimo ]  |
                c'' 8 _\markup { \bold \italic "stacc." } -\staccato [ < c'' a' > -\staccato < f' c'' > -\staccato < g' c'' > -\staccato ] < c'' d' > -\staccato [ < f' c'' > -\staccato < d' c'' > -\staccato < d' c'' > -\staccato ]  |
                < d' c'' > 8 _\markup { \bold \italic "spiccato" } -\staccato [ < e' c'' > -\staccato < c'' d' > -\staccato < c'' c' > -\staccato ] < fis'' c'' d' > 16 -\staccato [ < f'' c'' c' > -\staccato < e'' c'' bes > -\staccato < d'' c'' c' > -\staccato ] < d' c'' e'' > -\staccato [ < d' c'' f'' > 8. -\staccato ]  |
                < c'' a' d' g'' > 8 -\staccato [ < d' f'' c'' a' > -\staccato ] < e'' d' a' c'' > 4 -\staccato < d' e'' a' c'' > 2 -\staccato  |
                < d'' d''' > 16 _\markup { \bold \italic "jeté" } -\staccato ^( [ < d'' d''' > -\staccato < d''' d'' > -\staccato < d'' d''' > -\staccato ) ] r4 < d'' d''' > 16 _\markup { \bold \italic "balzato" } -\staccato ^( [ < d''' d'' > -\staccato < f'' c''' > -\staccato < d''' f'' > -\staccato ] < c''' f'' > -\staccato [ < d''' d'' > -\staccato ) ] r8  |
%% 35
                < d''' d'' > 8 [ < f'' a' > < e'' g' > < f'' f' > ] d' 2  |
                d' 1  |
                R1^\markup { \large "Left hand techniques" }   |
                \bar "|."
            } % Voice

            % End of segment Strings

            % End voice 0

            % cycle 1   verse line 1
            \new Lyrics
            \with {alignBelowContext="track 1"}
            \lyricsto "voice 0.0" {
                \lyricmode {
                    \override LyricText #'self-alignment-X = #LEFT
                    \set ignoreMelismata = ##t

                    % Segment "Strings": verse 1

                    %{   1 %}    _ _ _ _
                    %{   2 %}    _ _ _
                    %{   3 %}    _ _ _ _
                    %{   4 %}    _ _ _
                    %{   5 %}    _ _ _ _
                    %{   6 %}    _ _ _ _
                    %{   7 %}    _ _ _ _ _ _ _ _
                    %{   8 %}    _ _ _ _ _
                    %{   9 %}    _ _ _ _
                    %{  10 %}    _ _ _ _
                    %{  11 %}    _ _ _
                    %{  12 %}    _
                    %{  13 %}    _
                    %{  14 %}    _
                    %{  15 %}    _
                    %{  16 %}    _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
                    %{  17 %}    _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
                    %{  18 %}    _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
                    %{  19 %}    _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
                    %{  20 %}    _ _ _ _
                    %{  21 %}    _ _ _ _
                    %{  22 %}    _ _ _
                    %{  23 %}    _ _ _ _ _ _ _ _ _ _ _ _
                    %{  24 %}    _ _ _ _ _ _ _
                    %{  25 %}    _ _ _ _
                    %{  26 %}    _ _ _
                    %{  27 %}    _ _ _ _
                    %{  28 %}    _ _ _
                    %{  29 %}    _ _ _ _ _ _ _ _
                    %{  30 %}    _ _ _ _ _ _ _ _
                    %{  31 %}    _ _ _ _ _ _ _ _
                    %{  32 %}    _ _ _ _ _ _ _ _ _ _
                    %{  33 %}    _ _ _ _
                    %{  34 %}    _ _ _ _ _ _ _ _ _ _
                    %{  35 %}    _ _ _ _ _
                    %{  36 %}    _

                    \unset ignoreMelismata
                }
            } % Lyrics 
        >> % Staff ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
