% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{CreateAssay5Object}
\alias{CreateAssay5Object}
\title{Create a v5 Assay object}
\usage{
CreateAssay5Object(
  counts = NULL,
  data = NULL,
  min.cells = 0,
  min.features = 0,
  csum = NULL,
  fsum = NULL,
  ...
)
}
\arguments{
\item{counts}{A two-dimensional expression matrix}

\item{data}{Optional prenormalized data matrix}

\item{min.cells}{Include features detected in at least this many cells;
will subset the counts matrix as well. To reintroduce excluded features,
create a new object with a lower cutoff}

\item{min.features}{Include cells where at least this many features
are detected}

\item{csum}{Function for calculating cell sums}

\item{fsum}{Function for calculating feature sums}

\item{...}{Arguments passed to other methods}
}
\value{
An \code{\link{Assay5}} object
}
\description{
Create an \code{\link{Assay5}} object from a feature expression matrix;
the expected format of the matrix is features x cells
}
\concept{assay}
