% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_assessment.R
\name{rl_assessment}
\alias{rl_assessment}
\alias{rl_assessment_}
\title{Retrieve an assessment}
\usage{
rl_assessment(id, key = NULL, parse = TRUE, ...)

rl_assessment_(id, key = NULL, ...)
}
\arguments{
\item{id}{(integer) The unique identifier of the assessment.}

\item{key}{(character) An IUCN API token. See \code{\link[=rl_use_iucn]{rl_use_iucn()}}.}

\item{parse}{(logical) Whether to parse the output to list (\code{FALSE}) or,
where possible, data.frame (\code{TRUE}). Default: \code{TRUE}.}

\item{...}{Includes the following arguments related to the wait time between
request retries if a "Too Many Requests" error is received from the API
(see \link[crul:HttpClient]{HttpClient()$retry()} for more details):
\itemize{
\item \code{pause_base}, \code{pause_cap}, and \code{pause_min}: basis, maximum, and minimum
for calculating wait time for retry
\item \code{times}: the maximum number of times to retry
\item \code{onwait}: a callback function if the request will be retried and a
wait time is being applied
}
Also supports any \link[curl:curl_options]{curl options} passed to the GET
request via \link[crul:HttpClient]{HttpClient}.}
}
\value{
A list unless using a function with a trailing underscore, in which
case json as character string is returned.
}
\description{
Get the full details for a single IUCN Red List assessment.
}
\examples{
\dontrun{
# Get assessment details for Fratercula arctica
ex1 <- rl_assessment(id = 166290968)
ex1$red_list_category$code
ex1$systems
}
}
\references{
API docs at \url{https://api.iucnredlist.org/}.
}
