% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backport_linter.R
\name{backport_linter}
\alias{backport_linter}
\title{Backport linter}
\usage{
backport_linter(r_version = getRversion(), except = character())
}
\arguments{
\item{r_version}{Minimum R version to test for compatibility. Defaults to
the R version currently in use. The version can be specified as a version
number, or as a version alias (such as \code{"devel"}, \code{"oldrel"}, \code{"oldrel-1"}).}

\item{except}{Character vector of functions to be excluded from linting.
Use this to list explicitly defined backports, e.g. those imported from the \code{{backports}} package or manually
defined in your package.}
}
\description{
Check for usage of unavailable functions. Not reliable for testing r-devel dependencies.
}
\examples{
# will produce lints
lint(
  text = "trimws(x)",
  linters = backport_linter("3.0.0")
)

lint(
  text = "str2lang(x)",
  linters = backport_linter("3.2.0")
)

lint(
  text = "deparse1(expr)",
  linters = backport_linter("3.6.0")
)

# okay
lint(
  text = "trimws(x)",
  linters = backport_linter("3.6.0")
)

lint(
  text = "str2lang(x)",
  linters = backport_linter("3.2.0", except = "str2lang")
)

# Version aliases instead of numbers can also be passed to `r_version`
lint(
  text = "deparse1(expr)",
  linters = backport_linter("release")
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=package_development_linters]{package_development}, \link[=robustness_linters]{robustness}
}
