"""make reports multiworkspaces

Revision ID: 34468fcfd92e
Revises: 9f826327658a
Create Date: 2023-09-25 18:19:45.271406+00:00

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '34468fcfd92e'
down_revision = '9f826327658a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    executive_report_workspace_table = op.create_table('executive_report_workspace_table',
    sa.Column('workspace_id', sa.Integer(), nullable=True),
    sa.Column('executive_report_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['executive_report_id'], ['executive_report.id'], ),
    sa.ForeignKeyConstraint(['workspace_id'], ['workspace.id'], )
    )
    conn = op.get_bind()
    res = conn.execute(sa.text("SELECT executive_report.id, executive_report.workspace_id from executive_report"))
    op.bulk_insert(
        executive_report_workspace_table,
        [{"executive_report_id": r[0], "workspace_id": r[1]} for r in res]
    )
    op.drop_index('ix_executive_report_workspace_id', table_name='executive_report')
    op.drop_constraint('executive_report_workspace_id_fkey', 'executive_report', type_='foreignkey')
    op.drop_column('executive_report', 'workspace_id')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('executive_report', sa.Column('workspace_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_foreign_key('executive_report_workspace_id_fkey', 'executive_report', 'workspace', ['workspace_id'], ['id'])
    op.create_index('ix_executive_report_workspace_id', 'executive_report', ['workspace_id'], unique=False)
    conn = op.get_bind()
    res = conn.execute("SELECT DISTINCT executive_report_id, workspace_id from executive_report_workspace_table").fetchall()
    for r in res:
        conn.execute(sa.text("UPDATE executive_report SET workspace_id = :workspace_id WHERE id= :report_id"), **{"report_id": r[0], "workspace_id": r[1]})
    op.alter_column('executive_report', 'workspace_id', nullable=False)
    op.drop_table('executive_report_workspace_table')
    # ### end Alembic commands ###
