# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIDaprComponentResiliencyPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dapr_component_resiliency_policies_list(self, resource_group):
        response = self.client.dapr_component_resiliency_policies.list(
            resource_group_name=resource_group.name,
            environment_name="str",
            component_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dapr_component_resiliency_policies_get(self, resource_group):
        response = await self.client.dapr_component_resiliency_policies.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            component_name="str",
            name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dapr_component_resiliency_policies_create_or_update(self, resource_group):
        response = await self.client.dapr_component_resiliency_policies.create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            component_name="str",
            name="str",
            dapr_component_resiliency_policy_envelope={
                "id": "str",
                "inboundPolicy": {
                    "circuitBreakerPolicy": {"consecutiveErrors": 0, "intervalInSeconds": 0, "timeoutInSeconds": 0},
                    "httpRetryPolicy": {
                        "maxRetries": 0,
                        "retryBackOff": {"initialDelayInMilliseconds": 0, "maxIntervalInMilliseconds": 0},
                    },
                    "timeoutPolicy": {"responseTimeoutInSeconds": 0},
                },
                "name": "str",
                "outboundPolicy": {
                    "circuitBreakerPolicy": {"consecutiveErrors": 0, "intervalInSeconds": 0, "timeoutInSeconds": 0},
                    "httpRetryPolicy": {
                        "maxRetries": 0,
                        "retryBackOff": {"initialDelayInMilliseconds": 0, "maxIntervalInMilliseconds": 0},
                    },
                    "timeoutPolicy": {"responseTimeoutInSeconds": 0},
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dapr_component_resiliency_policies_delete(self, resource_group):
        response = await self.client.dapr_component_resiliency_policies.delete(
            resource_group_name=resource_group.name,
            environment_name="str",
            component_name="str",
            name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
