# -*- coding: utf-8 -*-

import os, time, random
from StringIO import StringIO
from smb.SMBConnection import SMBConnection
from smb.smb2_constants import SMB2_DIALECT_2
from util import getConnectionInfo
from nose.tools import with_setup
from smb import smb_structs

conn = None

def setup_func_SMB1():
    global conn
    smb_structs.SUPPORT_SMB2 = smb_structs.SUPPORT_SMB2x = False

    info = getConnectionInfo()
    conn = SMBConnection(info['user'], info['password'], info['client_name'], info['server_name'], use_ntlm_v2 = True)
    assert conn.connect(info['server_ip'], info['server_port'])

def setup_func_SMB2():
    global conn
    smb_structs.SUPPORT_SMB2 = True
    smb_structs.SUPPORT_SMB2x = False

    info = getConnectionInfo()
    conn = SMBConnection(info['user'], info['password'], info['client_name'], info['server_name'], use_ntlm_v2 = True)
    assert conn.connect(info['server_ip'], info['server_port'])

def setup_func_SMB2x():
    global conn
    smb_structs.SUPPORT_SMB2 = smb_structs.SUPPORT_SMB2x = True

    info = getConnectionInfo()
    conn = SMBConnection(info['user'], info['password'], info['client_name'], info['server_name'], use_ntlm_v2 = True)
    assert conn.connect(info['server_ip'], info['server_port'])

def teardown_func():
    global conn
    conn.close()

@with_setup(setup_func_SMB1, teardown_func)
def test_delete_SMB1():
    global conn

    path = os.sep + u'testDelete %d-%d' % ( time.time(), random.randint(0, 1000) )
    conn.createDirectory('smbtest', path)

    for filename in [ 'aaTest.txt', 'aaBest.txt', 'aaTest.bin', 'aaBest.bin', 'random.txt' ]:
        conn.storeFile('smbtest', path+"/"+filename, StringIO("0123456789"))

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' in filenames
    assert 'aaBest.txt' in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aa*.txt')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' not in filenames
    assert 'aaBest.txt' not in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aaTest.*')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.bin' not in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/*')
    conn.deleteDirectory('smbtest', path)

@with_setup(setup_func_SMB2, teardown_func)
def test_delete_SMB2():
    global conn
    assert conn.smb2_dialect == SMB2_DIALECT_2

    path = os.sep + u'testDelete %d-%d' % ( time.time(), random.randint(0, 1000) )
    conn.createDirectory('smbtest', path)

    for filename in [ 'aaTest.txt', 'aaBest.txt', 'aaTest.bin', 'aaBest.bin', 'random.txt' ]:
        conn.storeFile('smbtest', path+"/"+filename, StringIO("0123456789"))

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' in filenames
    assert 'aaBest.txt' in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aa*.txt')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' not in filenames
    assert 'aaBest.txt' not in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aaTest.*')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.bin' not in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

@with_setup(setup_func_SMB2x, teardown_func)
def test_delete_SMB2x():
    global conn
    assert conn.smb2_dialect != SMB2_DIALECT_2

    path = os.sep + u'testDelete %d-%d' % ( time.time(), random.randint(0, 1000) )
    conn.createDirectory('smbtest', path)

    for filename in [ 'aaTest.txt', 'aaBest.txt', 'aaTest.bin', 'aaBest.bin', 'random.txt' ]:
        conn.storeFile('smbtest', path+"/"+filename, StringIO("0123456789"))

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' in filenames
    assert 'aaBest.txt' in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aa*.txt')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.txt' not in filenames
    assert 'aaBest.txt' not in filenames
    assert 'aaTest.bin' in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames

    conn.deleteFiles('smbtest', path+'/aaTest.*')

    results = conn.listPath('smbtest', path)
    filenames = map(lambda r: r.filename, results)
    assert 'aaTest.bin' not in filenames
    assert 'aaBest.bin' in filenames
    assert 'random.txt' in filenames
