# encoding: utf-8
# A description of the file, used in verbose mode
$layout_description = "French keyboard layout"

$layout = {
	"²" => { 1 => "1&"},
	"1" => { 0 => "&",1 => "a2é~"},
	"2" => { 0 => "é~", 1 => "1&az3\"#"},
	"3" => { 0 => "\"#", 1 => "2é~4'{ze€"},
	"4" => { 0 => "'{", 1 => "3\"#er5(["},
	"5" => { 0 => "([", 1 => "4'{6-|rt"},
	"6" => { 0 => "-|", 1 => "5([7è`ty"},
	"7" => { 0 => "è`", 1 => "6-|8_\\yu"},
	"8" => { 0 => "_\\", 1 => "7è`9ç^ui"},
	"9" => { 0 => "ç^", 1 => "8_\\0à@io"},
	"0" => { 0 => "à@", 1 => "9ç^°)]op"},
	"°" => { 0 => ")]", 1 => "0à@+=}p^"},
	"+" => { 0 => "=}", 1 => "°)]$£ø"},
	"&" => { 0 => "&",1 => "a2é~"},
	"é" => { 0 => "2~", 1 => "1&az3\"#"},
	"\"" => { 0 => "3#", 1 => "2é~4'{ze€"},
	"'" => { 0 => "4{", 1 => "3\"#er5(["},
	"(" => { 0 => "5[", 1 => "4'{6-|rt"},
	"-" => { 0 => "6|", 1 => "5([7è`ty"},
	"è" => { 0 => "7`", 1 => "6-|8_\\yu"},
	"_" => { 0 => "8\\", 1 => "7è`9ç^ui"},
	"ç" => { 0 => "9^", 1 => "8_\\0à@io"},
	"à" => { 0 => "0@", 1 => "9ç^°)]op"},
	")" => { 0 => "°]", 1 => "0à@+=}^p"},
	"=" => { 0 => "+}", 1 => "°)]$£ø"},
	"~" => { 0 => "é2", 1 => "1&az3\"#"},
	"#" => { 0 => "\"3", 1 => "2é~4'{ze€"},
	"{" => { 0 => "'4", 1 => "3\"#er5(["},
	"[" => { 0 => "(5", 1 => "4'{6-|rt"},
	"|" => { 0 => "-6", 1 => "5([7è`ty"},
	"`" => { 0 => "è7", 1 => "6-|8_\\yu"},
	"\\" => { 0 => "_8", 1 => "7è`9ç^ui"},
	"^" => { 0 => "ç9", 1 => "8_\\0à@io"},
	"@" => { 0 => "à0", 1 => "9ç^°)]op"},
	"]" => { 0 => ")°", 1 => "0à@+=}p"},
	"}" => { 0 => "=+", 1 => "°)]$£ø"},
	"a" => { 1 => "1&2éqz"},
	"z" => { 1 => "aqse€2é~3\"#"},
	"e" => { 0 => "€", 1 => "zsdr3\"#4'{"},
	"€" => { 0 => "e", 1 => "zsdr3\"#4'{"},
	"r" => { 1 => "e€dft4'{5(["},
	"t" => { 1 => "rfgy5([6-|"},
	"y" => { 1 => "tghu6-|7è`"},
	"u" => { 1 => "yhji7è`8_\\"},
	"i" => { 1 => "ujko8_\\9ç^"},
	"o" => { 1 => "iklp9ç^0à@"},
	"p" => { 1 => "olm0à@°)]"},
	"$" => { 0 => "£ø", 1 => "ù%*µ+=}"},
	"£" => { 0 => "$ø", 1 => "ù%*µ+=}"},
	"ø" => { 0 => "£$", 1 => "ù%*µ+=}"},
	"q" => { 1 => "azsw<>"},
	"s" => { 1 => "ze€dxwq"},
	"d" => { 1 => "e€rfcxs"},
	"f" => { 1 => "rtgvcd"},
	"g" => { 1 => "tyhbvf"},
	"h" => { 1 => "yujnbg"},
	"j" => { 1 => "uik,?nh"},
	"k" => { 1 => "iol;.,?j"},
	"l" => { 1 => "opm:/;.k"},
	"m" => { 1 => "pù%!§:/l"},
	"ù" => { 0 => "%", 1 => "$£ø*µ!§m"},
	"%" => { 0 => "ù", 1 => "$£ø*µ!§m"},
	"*" => { 0 => "µ", 1 => "$£øù%"},
	"µ" => { 0 => "*", 1 => "$£øù%"},
	"<" => { 1 => "qw"},
	">" => { 1 => "qw"},
	"w" => { 1 => "<>qsx"},
	"x" => { 1 => "wsdc"},
	"c" => { 1 => "xdfv"},
	"v" => { 1 => "cfgb"},
	"b" => { 1 => "vghn"},
	"n" => { 1 => "bhj,?"},
	"," => { 0 => "?", 1 => "njk;."},
	"?" => { 0 => ",", 1 => "njk;."},
	";" => { 0 => ".", 1 => ",?kl:/"},
	"." => { 0 => ";", 1 => ",?kl:/"},
	":" => { 0 => "/", 1 => ";.lm!§"},
	"/" => { 0 => ":", 1 => ";.lm!§"},
	"!" => { 0 => "§", 1 => ":/mù%"},
	"§" => { 0 => "!", 1 => ":/mù%"},
}

# This is the furthest distance we are looking for as a jump + 1
# This could be calculated by the app when it starts up but that 
# seems like unnecessary work as you already know it when creating
# this file.
#
# You could also chose to penalise keys further away more by giving
# them a higher score.
MAX_SCORE = 2
